/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.DownloadApiModel;
import com.stackone.stackone_client_java.models.errors.BadGatewayResponse;
import com.stackone.stackone_client_java.models.errors.BadRequestResponse;
import com.stackone.stackone_client_java.models.errors.ConflictResponse;
import com.stackone.stackone_client_java.models.errors.ForbiddenResponse;
import com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse;
import com.stackone.stackone_client_java.models.errors.NotFoundResponse;
import com.stackone.stackone_client_java.models.errors.NotImplementedResponse;
import com.stackone.stackone_client_java.models.errors.PreconditionFailedResponse;
import com.stackone.stackone_client_java.models.errors.RequestTimedOutResponse;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse;
import com.stackone.stackone_client_java.models.errors.UnauthorizedResponse;
import com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse;
import com.stackone.stackone_client_java.models.operations.AtsDownloadApplicationDocumentRequest;
import com.stackone.stackone_client_java.models.operations.AtsDownloadApplicationDocumentResponse;
import com.stackone.stackone_client_java.operations.Operations;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class AtsDownloadApplicationDocument {

    public static class Sync
    extends Base
    implements Operations.RequestOperation<AtsDownloadApplicationDocumentRequest, AtsDownloadApplicationDocumentResponse> {
        public Sync(SDKConfiguration sdkConfiguration, Optional<Options> options) {
            super(sdkConfiguration, options);
        }

        private HttpRequest onBuildRequest(AtsDownloadApplicationDocumentRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request);
            return this.sdkConfiguration.hooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
            return this.sdkConfiguration.hooks().afterError(this.createAfterErrorContext(), Optional.ofNullable(response), Optional.ofNullable(error));
        }

        private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
            return this.sdkConfiguration.hooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public HttpResponse<InputStream> doRequest(AtsDownloadApplicationDocumentRequest request) throws Exception {
            Retries retries = Retries.builder().action(() -> {
                HttpRequest r;
                try {
                    r = this.onBuildRequest(request);
                }
                catch (Exception e) {
                    throw new Retries.NonRetryableException(e);
                }
                try {
                    HttpResponse<InputStream> httpRes = this.client.send(r);
                    if (Utils.statusCodeMatches(httpRes.statusCode(), "400", "401", "403", "404", "408", "409", "412", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                        return this.onError(httpRes, null);
                    }
                    return httpRes;
                }
                catch (Exception e) {
                    return this.onError(null, e);
                }
            }).retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).build();
            return this.onSuccess(retries.run());
        }

        @Override
        public AtsDownloadApplicationDocumentResponse handleResponse(HttpResponse<InputStream> response) throws Exception {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            AtsDownloadApplicationDocumentResponse.Builder resBuilder = AtsDownloadApplicationDocumentResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            AtsDownloadApplicationDocumentResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/gzip")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/msword")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/octet-stream")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/pdf")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/rtf")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.ms-excel")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.ms-outlook")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.ms-powerpoint")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.presentation")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.spreadsheet")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.text")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/x-7z-compressed")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/x-rar-compressed")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/xml")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/zip")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "audio/mp4")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "audio/mpeg")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "audio/wav")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/bmp")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/gif")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/heic")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/jpeg")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/png")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/tiff")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/webp")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "message/rfc822")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "text/csv")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "text/html")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "text/rtf")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "video/avi")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "video/mp4")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "video/quicktime")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "video/webm")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "text/plain")) {
                    String out = Utils.toUtf8AndClose(response.body());
                    res.withDownloadApiModel(out);
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    DownloadApiModel out = (DownloadApiModel)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<DownloadApiModel>(){});
                    res.withDownloadApiModel1(out);
                    return res;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    BadRequestResponse out = (BadRequestResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<BadRequestResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    UnauthorizedResponse out = (UnauthorizedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<UnauthorizedResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ForbiddenResponse out = (ForbiddenResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ForbiddenResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    NotFoundResponse out = (NotFoundResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<NotFoundResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    RequestTimedOutResponse out = (RequestTimedOutResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<RequestTimedOutResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ConflictResponse out = (ConflictResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ConflictResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "412")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    PreconditionFailedResponse out = (PreconditionFailedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<PreconditionFailedResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    UnprocessableEntityResponse out = (UnprocessableEntityResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<UnprocessableEntityResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    TooManyRequestsResponse out = (TooManyRequestsResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<TooManyRequestsResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    InternalServerErrorResponse out = (InternalServerErrorResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<InternalServerErrorResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    NotImplementedResponse out = (NotImplementedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<NotImplementedResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    BadGatewayResponse out = (BadGatewayResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<BadGatewayResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
            }
            throw new SDKError(response, response.statusCode(), "Unexpected status code received: " + response.statusCode(), Utils.extractByteArrayFromBody(response));
        }
    }

    static abstract class Base {
        final SDKConfiguration sdkConfiguration;
        final String baseUrl;
        final SecuritySource securitySource;
        final List<String> retryStatusCodes;
        final RetryConfig retryConfig;
        final HTTPClient client;

        public Base(SDKConfiguration sdkConfiguration, Optional<Options> options) {
            this.sdkConfiguration = sdkConfiguration;
            this.baseUrl = this.sdkConfiguration.serverUrl();
            this.securitySource = this.sdkConfiguration.securitySource();
            options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
            this.retryStatusCodes = List.of("429", "408");
            this.retryConfig = options.flatMap(Options::retryConfig).or(sdkConfiguration::retryConfig).orElse(RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
            this.client = this.sdkConfiguration.client();
        }

        Optional<SecuritySource> securitySource() {
            return Optional.ofNullable(this.securitySource);
        }

        Hook.BeforeRequestContextImpl createBeforeRequestContext() {
            return new Hook.BeforeRequestContextImpl(this.sdkConfiguration, this.baseUrl, "ats_download_application_document", Optional.of(List.of()), this.securitySource());
        }

        Hook.AfterSuccessContextImpl createAfterSuccessContext() {
            return new Hook.AfterSuccessContextImpl(this.sdkConfiguration, this.baseUrl, "ats_download_application_document", Optional.of(List.of()), this.securitySource());
        }

        Hook.AfterErrorContextImpl createAfterErrorContext() {
            return new Hook.AfterErrorContextImpl(this.sdkConfiguration, this.baseUrl, "ats_download_application_document", Optional.of(List.of()), this.securitySource());
        }

        HttpRequest buildRequest(AtsDownloadApplicationDocumentRequest request) throws Exception {
            String url = Utils.generateURL(AtsDownloadApplicationDocumentRequest.class, this.baseUrl, "/unified/ats/applications/{id}/documents/{subResourceId}/download", request, null);
            HTTPRequest req = new HTTPRequest(url, "GET");
            req.addHeader("Accept", "application/json;q=1, text/csv;q=0.97, text/plain;q=0.95, application/gzip;q=0.92, application/msword;q=0.89, application/octet-stream;q=0.87, application/pdf;q=0.84, application/rtf;q=0.82, application/vnd.ms-excel;q=0.79, application/vnd.ms-outlook;q=0.76, application/vnd.ms-powerpoint;q=0.74, application/vnd.oasis.opendocument.presentation;q=0.71, application/vnd.oasis.opendocument.spreadsheet;q=0.68, application/vnd.oasis.opendocument.text;q=0.66, application/vnd.openxmlformats-officedocument.presentationml.presentation;q=0.63, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;q=0.61, application/vnd.openxmlformats-officedocument.wordprocessingml.document;q=0.58, application/x-7z-compressed;q=0.55, application/x-rar-compressed;q=0.53, application/xml;q=0.50, application/zip;q=0.47, audio/mp4;q=0.45, audio/mpeg;q=0.42, audio/wav;q=0.39, image/bmp;q=0.37, image/gif;q=0.34, image/heic;q=0.32, image/jpeg;q=0.29, image/png;q=0.26, image/tiff;q=0.24, image/webp;q=0.21, message/rfc822;q=0.18, text/html;q=0.16, text/rtf;q=0.13, video/avi;q=0.11, video/mp4;q=0.08, video/quicktime;q=0.05, video/webm;q=0").addHeader("user-agent", SDKConfiguration.USER_AGENT);
            req.addQueryParams(Utils.getQueryParams(AtsDownloadApplicationDocumentRequest.class, request, null));
            req.addHeaders(Utils.getHeadersFromMetadata(request, null));
            Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());
            return req.build();
        }
    }
}

