/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class IamGroupValue {
    public static final IamGroupValue WORKSPACE = new IamGroupValue("workspace");
    public static final IamGroupValue TEAM = new IamGroupValue("team");
    public static final IamGroupValue DEPARTMENT = new IamGroupValue("department");
    public static final IamGroupValue GROUP = new IamGroupValue("group");
    public static final IamGroupValue ORGANIZATION = new IamGroupValue("organization");
    public static final IamGroupValue UNMAPPED_VALUE = new IamGroupValue("unmapped_value");
    public static final IamGroupValue COST_CENTER = new IamGroupValue("cost_center");
    private static final Map<String, IamGroupValue> values = IamGroupValue.createValuesMap();
    private static final Map<String, IamGroupValueEnum> enums = IamGroupValue.createEnumsMap();
    private final String value;

    private IamGroupValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IamGroupValue of(String value) {
        Class<IamGroupValue> clazz = IamGroupValue.class;
        synchronized (IamGroupValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new IamGroupValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<IamGroupValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IamGroupValue other = (IamGroupValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "IamGroupValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IamGroupValue[] values() {
        Class<IamGroupValue> clazz = IamGroupValue.class;
        synchronized (IamGroupValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new IamGroupValue[0]);
        }
    }

    private static final Map<String, IamGroupValue> createValuesMap() {
        LinkedHashMap<String, IamGroupValue> map = new LinkedHashMap<String, IamGroupValue>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, IamGroupValueEnum> createEnumsMap() {
        HashMap<String, IamGroupValueEnum> map = new HashMap<String, IamGroupValueEnum>();
        map.put("workspace", IamGroupValueEnum.WORKSPACE);
        map.put("team", IamGroupValueEnum.TEAM);
        map.put("department", IamGroupValueEnum.DEPARTMENT);
        map.put("group", IamGroupValueEnum.GROUP);
        map.put("organization", IamGroupValueEnum.ORGANIZATION);
        map.put("unmapped_value", IamGroupValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", IamGroupValueEnum.COST_CENTER);
        return map;
    }

    public static enum IamGroupValueEnum {
        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center");

        private final String value;

        private IamGroupValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<IamGroupValue> {
        protected _Deserializer() {
            super(IamGroupValue.class);
        }

        public IamGroupValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return IamGroupValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<IamGroupValue> {
        protected _Serializer() {
            super(IamGroupValue.class);
        }

        public void serialize(IamGroupValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

