/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class PushMessagesValue {
    public static final PushMessagesValue EMAIL = new PushMessagesValue("email");
    public static final PushMessagesValue SMS = new PushMessagesValue("sms");
    public static final PushMessagesValue PUSH = new PushMessagesValue("push");
    public static final PushMessagesValue WEB_PUSH = new PushMessagesValue("web_push");
    public static final PushMessagesValue IOS_PUSH = new PushMessagesValue("ios_push");
    public static final PushMessagesValue ANDROID_PUSH = new PushMessagesValue("android_push");
    public static final PushMessagesValue APP_PUSH = new PushMessagesValue("app_push");
    public static final PushMessagesValue OMNI_CHANNEL = new PushMessagesValue("omni_channel");
    public static final PushMessagesValue CONTENT_BLOCK = new PushMessagesValue("content_block");
    public static final PushMessagesValue IN_APP = new PushMessagesValue("in_app");
    public static final PushMessagesValue UNKNOWN = new PushMessagesValue("unknown");
    public static final PushMessagesValue UNMAPPED_VALUE = new PushMessagesValue("unmapped_value");
    private static final Map<String, PushMessagesValue> values = PushMessagesValue.createValuesMap();
    private static final Map<String, PushMessagesValueEnum> enums = PushMessagesValue.createEnumsMap();
    private final String value;

    private PushMessagesValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PushMessagesValue of(String value) {
        Class<PushMessagesValue> clazz = PushMessagesValue.class;
        synchronized (PushMessagesValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new PushMessagesValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<PushMessagesValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PushMessagesValue other = (PushMessagesValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "PushMessagesValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PushMessagesValue[] values() {
        Class<PushMessagesValue> clazz = PushMessagesValue.class;
        synchronized (PushMessagesValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new PushMessagesValue[0]);
        }
    }

    private static final Map<String, PushMessagesValue> createValuesMap() {
        LinkedHashMap<String, PushMessagesValue> map = new LinkedHashMap<String, PushMessagesValue>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("push", PUSH);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("app_push", APP_PUSH);
        map.put("omni_channel", OMNI_CHANNEL);
        map.put("content_block", CONTENT_BLOCK);
        map.put("in_app", IN_APP);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, PushMessagesValueEnum> createEnumsMap() {
        HashMap<String, PushMessagesValueEnum> map = new HashMap<String, PushMessagesValueEnum>();
        map.put("email", PushMessagesValueEnum.EMAIL);
        map.put("sms", PushMessagesValueEnum.SMS);
        map.put("push", PushMessagesValueEnum.PUSH);
        map.put("web_push", PushMessagesValueEnum.WEB_PUSH);
        map.put("ios_push", PushMessagesValueEnum.IOS_PUSH);
        map.put("android_push", PushMessagesValueEnum.ANDROID_PUSH);
        map.put("app_push", PushMessagesValueEnum.APP_PUSH);
        map.put("omni_channel", PushMessagesValueEnum.OMNI_CHANNEL);
        map.put("content_block", PushMessagesValueEnum.CONTENT_BLOCK);
        map.put("in_app", PushMessagesValueEnum.IN_APP);
        map.put("unknown", PushMessagesValueEnum.UNKNOWN);
        map.put("unmapped_value", PushMessagesValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum PushMessagesValueEnum {
        EMAIL("email"),
        SMS("sms"),
        PUSH("push"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        APP_PUSH("app_push"),
        OMNI_CHANNEL("omni_channel"),
        CONTENT_BLOCK("content_block"),
        IN_APP("in_app"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private PushMessagesValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<PushMessagesValue> {
        protected _Deserializer() {
            super(PushMessagesValue.class);
        }

        public PushMessagesValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return PushMessagesValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<PushMessagesValue> {
        protected _Serializer() {
            super(PushMessagesValue.class);
        }

        public void serialize(PushMessagesValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

