/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.InterviewsResult;
import com.stackone.stackone_client_java.models.errors.BadGatewayResponse;
import com.stackone.stackone_client_java.models.errors.BadRequestResponse;
import com.stackone.stackone_client_java.models.errors.ConflictResponse;
import com.stackone.stackone_client_java.models.errors.ForbiddenResponse;
import com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse;
import com.stackone.stackone_client_java.models.errors.NotFoundResponse;
import com.stackone.stackone_client_java.models.errors.NotImplementedResponse;
import com.stackone.stackone_client_java.models.errors.PreconditionFailedResponse;
import com.stackone.stackone_client_java.models.errors.RequestTimedOutResponse;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse;
import com.stackone.stackone_client_java.models.errors.UnauthorizedResponse;
import com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse;
import com.stackone.stackone_client_java.models.operations.AtsGetInterviewRequest;
import com.stackone.stackone_client_java.models.operations.AtsGetInterviewResponse;
import com.stackone.stackone_client_java.operations.Operations;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class AtsGetInterview {

    public static class Sync
    extends Base
    implements Operations.RequestOperation<AtsGetInterviewRequest, AtsGetInterviewResponse> {
        public Sync(SDKConfiguration sdkConfiguration, Optional<Options> options) {
            super(sdkConfiguration, options);
        }

        private HttpRequest onBuildRequest(AtsGetInterviewRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request);
            return this.sdkConfiguration.hooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
            return this.sdkConfiguration.hooks().afterError(this.createAfterErrorContext(), Optional.ofNullable(response), Optional.ofNullable(error));
        }

        private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
            return this.sdkConfiguration.hooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public HttpResponse<InputStream> doRequest(AtsGetInterviewRequest request) throws Exception {
            Retries retries = Retries.builder().action(() -> {
                HttpRequest r;
                try {
                    r = this.onBuildRequest(request);
                }
                catch (Exception e) {
                    throw new Retries.NonRetryableException(e);
                }
                try {
                    HttpResponse<InputStream> httpRes = this.client.send(r);
                    if (Utils.statusCodeMatches(httpRes.statusCode(), "400", "401", "403", "404", "408", "409", "412", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                        return this.onError(httpRes, null);
                    }
                    return httpRes;
                }
                catch (Exception e) {
                    return this.onError(null, e);
                }
            }).retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).build();
            return this.onSuccess(retries.run());
        }

        @Override
        public AtsGetInterviewResponse handleResponse(HttpResponse<InputStream> response) throws Exception {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            AtsGetInterviewResponse.Builder resBuilder = AtsGetInterviewResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            AtsGetInterviewResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    InterviewsResult out = (InterviewsResult)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<InterviewsResult>(){});
                    res.withInterviewsResult(out);
                    return res;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    BadRequestResponse out = (BadRequestResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<BadRequestResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    UnauthorizedResponse out = (UnauthorizedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<UnauthorizedResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ForbiddenResponse out = (ForbiddenResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ForbiddenResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    NotFoundResponse out = (NotFoundResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<NotFoundResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    RequestTimedOutResponse out = (RequestTimedOutResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<RequestTimedOutResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ConflictResponse out = (ConflictResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ConflictResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "412")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    PreconditionFailedResponse out = (PreconditionFailedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<PreconditionFailedResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    UnprocessableEntityResponse out = (UnprocessableEntityResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<UnprocessableEntityResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    TooManyRequestsResponse out = (TooManyRequestsResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<TooManyRequestsResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    InternalServerErrorResponse out = (InternalServerErrorResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<InternalServerErrorResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    NotImplementedResponse out = (NotImplementedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<NotImplementedResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    BadGatewayResponse out = (BadGatewayResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<BadGatewayResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
            }
            throw new SDKError(response, response.statusCode(), "Unexpected status code received: " + response.statusCode(), Utils.extractByteArrayFromBody(response));
        }
    }

    static abstract class Base {
        final SDKConfiguration sdkConfiguration;
        final String baseUrl;
        final SecuritySource securitySource;
        final List<String> retryStatusCodes;
        final RetryConfig retryConfig;
        final HTTPClient client;

        public Base(SDKConfiguration sdkConfiguration, Optional<Options> options) {
            this.sdkConfiguration = sdkConfiguration;
            this.baseUrl = this.sdkConfiguration.serverUrl();
            this.securitySource = this.sdkConfiguration.securitySource();
            options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
            this.retryStatusCodes = List.of("429", "408");
            this.retryConfig = options.flatMap(Options::retryConfig).or(sdkConfiguration::retryConfig).orElse(RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
            this.client = this.sdkConfiguration.client();
        }

        Optional<SecuritySource> securitySource() {
            return Optional.ofNullable(this.securitySource);
        }

        Hook.BeforeRequestContextImpl createBeforeRequestContext() {
            return new Hook.BeforeRequestContextImpl(this.sdkConfiguration, this.baseUrl, "ats_get_interview", Optional.of(List.of()), this.securitySource());
        }

        Hook.AfterSuccessContextImpl createAfterSuccessContext() {
            return new Hook.AfterSuccessContextImpl(this.sdkConfiguration, this.baseUrl, "ats_get_interview", Optional.of(List.of()), this.securitySource());
        }

        Hook.AfterErrorContextImpl createAfterErrorContext() {
            return new Hook.AfterErrorContextImpl(this.sdkConfiguration, this.baseUrl, "ats_get_interview", Optional.of(List.of()), this.securitySource());
        }

        HttpRequest buildRequest(AtsGetInterviewRequest request) throws Exception {
            String url = Utils.generateURL(AtsGetInterviewRequest.class, this.baseUrl, "/unified/ats/interviews/{id}", request, null);
            HTTPRequest req = new HTTPRequest(url, "GET");
            req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
            req.addQueryParams(Utils.getQueryParams(AtsGetInterviewRequest.class, request, null));
            req.addHeaders(Utils.getHeadersFromMetadata(request, null));
            Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());
            return req.build();
        }
    }
}

