/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingConversationResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MessagingGetConversationResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends MessagingConversationResult> messagingConversationResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MessagingGetConversationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends MessagingConversationResult> messagingConversationResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(messagingConversationResult, "messagingConversationResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.messagingConversationResult = messagingConversationResult;
        this.headers = headers;
    }

    public MessagingGetConversationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<MessagingConversationResult> messagingConversationResult() {
        return this.messagingConversationResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessagingGetConversationResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MessagingGetConversationResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MessagingGetConversationResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MessagingGetConversationResponse withMessagingConversationResult(MessagingConversationResult messagingConversationResult) {
        Utils.checkNotNull(messagingConversationResult, "messagingConversationResult");
        this.messagingConversationResult = Optional.ofNullable(messagingConversationResult);
        return this;
    }

    public MessagingGetConversationResponse withMessagingConversationResult(Optional<? extends MessagingConversationResult> messagingConversationResult) {
        Utils.checkNotNull(messagingConversationResult, "messagingConversationResult");
        this.messagingConversationResult = messagingConversationResult;
        return this;
    }

    public MessagingGetConversationResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingGetConversationResponse other = (MessagingGetConversationResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.messagingConversationResult, other.messagingConversationResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.messagingConversationResult, this.headers);
    }

    public String toString() {
        return Utils.toString(MessagingGetConversationResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "messagingConversationResult", this.messagingConversationResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends MessagingConversationResult> messagingConversationResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder messagingConversationResult(MessagingConversationResult messagingConversationResult) {
            Utils.checkNotNull(messagingConversationResult, "messagingConversationResult");
            this.messagingConversationResult = Optional.ofNullable(messagingConversationResult);
            return this;
        }

        public Builder messagingConversationResult(Optional<? extends MessagingConversationResult> messagingConversationResult) {
            Utils.checkNotNull(messagingConversationResult, "messagingConversationResult");
            this.messagingConversationResult = messagingConversationResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MessagingGetConversationResponse build() {
            return new MessagingGetConversationResponse(this.contentType, this.statusCode, this.rawResponse, this.messagingConversationResult, this.headers);
        }
    }
}

