/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingAttachmentsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MessagingListAttachmentsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends MessagingAttachmentsPaginated> messagingAttachmentsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MessagingListAttachmentsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends MessagingAttachmentsPaginated> messagingAttachmentsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(messagingAttachmentsPaginated, "messagingAttachmentsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.messagingAttachmentsPaginated = messagingAttachmentsPaginated;
        this.headers = headers;
    }

    public MessagingListAttachmentsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<MessagingAttachmentsPaginated> messagingAttachmentsPaginated() {
        return this.messagingAttachmentsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessagingListAttachmentsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MessagingListAttachmentsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MessagingListAttachmentsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MessagingListAttachmentsResponse withMessagingAttachmentsPaginated(MessagingAttachmentsPaginated messagingAttachmentsPaginated) {
        Utils.checkNotNull(messagingAttachmentsPaginated, "messagingAttachmentsPaginated");
        this.messagingAttachmentsPaginated = Optional.ofNullable(messagingAttachmentsPaginated);
        return this;
    }

    public MessagingListAttachmentsResponse withMessagingAttachmentsPaginated(Optional<? extends MessagingAttachmentsPaginated> messagingAttachmentsPaginated) {
        Utils.checkNotNull(messagingAttachmentsPaginated, "messagingAttachmentsPaginated");
        this.messagingAttachmentsPaginated = messagingAttachmentsPaginated;
        return this;
    }

    public MessagingListAttachmentsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingListAttachmentsResponse other = (MessagingListAttachmentsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.messagingAttachmentsPaginated, other.messagingAttachmentsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.messagingAttachmentsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MessagingListAttachmentsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "messagingAttachmentsPaginated", this.messagingAttachmentsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends MessagingAttachmentsPaginated> messagingAttachmentsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder messagingAttachmentsPaginated(MessagingAttachmentsPaginated messagingAttachmentsPaginated) {
            Utils.checkNotNull(messagingAttachmentsPaginated, "messagingAttachmentsPaginated");
            this.messagingAttachmentsPaginated = Optional.ofNullable(messagingAttachmentsPaginated);
            return this;
        }

        public Builder messagingAttachmentsPaginated(Optional<? extends MessagingAttachmentsPaginated> messagingAttachmentsPaginated) {
            Utils.checkNotNull(messagingAttachmentsPaginated, "messagingAttachmentsPaginated");
            this.messagingAttachmentsPaginated = messagingAttachmentsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MessagingListAttachmentsResponse build() {
            return new MessagingListAttachmentsResponse(this.contentType, this.statusCode, this.rawResponse, this.messagingAttachmentsPaginated, this.headers);
        }
    }
}

