/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.IamGroupResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class IamGetGroupResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends IamGroupResult> iamGroupResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public IamGetGroupResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends IamGroupResult> iamGroupResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(iamGroupResult, "iamGroupResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.iamGroupResult = iamGroupResult;
        this.headers = headers;
    }

    public IamGetGroupResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<IamGroupResult> iamGroupResult() {
        return this.iamGroupResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public IamGetGroupResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public IamGetGroupResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public IamGetGroupResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public IamGetGroupResponse withIamGroupResult(IamGroupResult iamGroupResult) {
        Utils.checkNotNull(iamGroupResult, "iamGroupResult");
        this.iamGroupResult = Optional.ofNullable(iamGroupResult);
        return this;
    }

    public IamGetGroupResponse withIamGroupResult(Optional<? extends IamGroupResult> iamGroupResult) {
        Utils.checkNotNull(iamGroupResult, "iamGroupResult");
        this.iamGroupResult = iamGroupResult;
        return this;
    }

    public IamGetGroupResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamGetGroupResponse other = (IamGetGroupResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.iamGroupResult, other.iamGroupResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.iamGroupResult, this.headers);
    }

    public String toString() {
        return Utils.toString(IamGetGroupResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "iamGroupResult", this.iamGroupResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends IamGroupResult> iamGroupResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder iamGroupResult(IamGroupResult iamGroupResult) {
            Utils.checkNotNull(iamGroupResult, "iamGroupResult");
            this.iamGroupResult = Optional.ofNullable(iamGroupResult);
            return this;
        }

        public Builder iamGroupResult(Optional<? extends IamGroupResult> iamGroupResult) {
            Utils.checkNotNull(iamGroupResult, "iamGroupResult");
            this.iamGroupResult = iamGroupResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public IamGetGroupResponse build() {
            return new IamGetGroupResponse(this.contentType, this.statusCode, this.rawResponse, this.iamGroupResult, this.headers);
        }
    }
}

