/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HRISTeamsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListTeamGroupsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends HRISTeamsPaginated> hrisTeamsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListTeamGroupsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends HRISTeamsPaginated> hrisTeamsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisTeamsPaginated, "hrisTeamsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisTeamsPaginated = hrisTeamsPaginated;
        this.headers = headers;
    }

    public HrisListTeamGroupsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HRISTeamsPaginated> hrisTeamsPaginated() {
        return this.hrisTeamsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListTeamGroupsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListTeamGroupsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListTeamGroupsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListTeamGroupsResponse withHRISTeamsPaginated(HRISTeamsPaginated hrisTeamsPaginated) {
        Utils.checkNotNull(hrisTeamsPaginated, "hrisTeamsPaginated");
        this.hrisTeamsPaginated = Optional.ofNullable(hrisTeamsPaginated);
        return this;
    }

    public HrisListTeamGroupsResponse withHRISTeamsPaginated(Optional<? extends HRISTeamsPaginated> hrisTeamsPaginated) {
        Utils.checkNotNull(hrisTeamsPaginated, "hrisTeamsPaginated");
        this.hrisTeamsPaginated = hrisTeamsPaginated;
        return this;
    }

    public HrisListTeamGroupsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListTeamGroupsResponse other = (HrisListTeamGroupsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisTeamsPaginated, other.hrisTeamsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisTeamsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListTeamGroupsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisTeamsPaginated", this.hrisTeamsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends HRISTeamsPaginated> hrisTeamsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisTeamsPaginated(HRISTeamsPaginated hrisTeamsPaginated) {
            Utils.checkNotNull(hrisTeamsPaginated, "hrisTeamsPaginated");
            this.hrisTeamsPaginated = Optional.ofNullable(hrisTeamsPaginated);
            return this;
        }

        public Builder hrisTeamsPaginated(Optional<? extends HRISTeamsPaginated> hrisTeamsPaginated) {
            Utils.checkNotNull(hrisTeamsPaginated, "hrisTeamsPaginated");
            this.hrisTeamsPaginated = hrisTeamsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListTeamGroupsResponse build() {
            return new HrisListTeamGroupsResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisTeamsPaginated, this.headers);
        }
    }
}

