/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.Helpers;
import com.stackone.stackone_client_java.utils.ResponseWithBody;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SpeakeasyHTTPClient
implements HTTPClient {
    private static boolean debugEnabled = false;
    private Boolean localDebugEnabled;
    private static Set<String> redactedHeaders = Set.of("AUTHORIZATION", "X-API-KEY");
    private static Consumer<? super String> logger = System.out::println;
    private final HttpClient client = HttpClient.newHttpClient();

    public static void setDebugLogging(boolean enabled) {
        debugEnabled = enabled;
    }

    public static boolean getDebugLoggingEnabled() {
        return debugEnabled;
    }

    @Override
    public boolean isDebugLoggingEnabled() {
        return Optional.ofNullable(this.localDebugEnabled).orElse(debugEnabled);
    }

    @Override
    public void enableDebugLogging(boolean enabled) {
        this.localDebugEnabled = enabled;
    }

    public static void setRedactedHeaders(Collection<String> headerNames) {
        redactedHeaders = headerNames.stream().map(x -> x.toUpperCase(Locale.ENGLISH)).collect(Collectors.toSet());
    }

    public static void addRedactedHeader(String headerName) {
        HashSet<String> updated = new HashSet<String>(redactedHeaders);
        updated.add(headerName.toUpperCase(Locale.ENGLISH));
        redactedHeaders = Set.copyOf(updated);
    }

    public static void setLogger(Consumer<? super String> logger) {
        SpeakeasyHTTPClient.logger = logger;
    }

    @Override
    public HttpResponse<InputStream> send(HttpRequest request) throws IOException, InterruptedException, URISyntaxException {
        if (this.isDebugLoggingEnabled()) {
            request = this.logRequest(request, true);
        }
        HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        if (this.isDebugLoggingEnabled()) {
            response = SpeakeasyHTTPClient.logResponse(response, true);
        }
        return response;
    }

    @Override
    public CompletableFuture<HttpResponse<Blob>> sendAsync(HttpRequest request) {
        if (this.isDebugLoggingEnabled()) {
            request = this.logRequest(request, true);
        }
        return this.client.sendAsync(request, HttpResponse.BodyHandlers.ofPublisher()).thenApply(response -> new ResponseWithBody(response, Blob::from));
    }

    private HttpRequest logRequest(HttpRequest request, boolean logBody) {
        SpeakeasyHTTPClient.log("Sending request: " + String.valueOf(request));
        SpeakeasyHTTPClient.log("Request headers: " + SpeakeasyHTTPClient.redactHeaders(request.headers()));
        if (logBody && request.bodyPublisher().isPresent() && request.headers().firstValue("Content-Type").filter(x -> x.equals("application/json") || x.equals("text/plain")).isPresent()) {
            byte[] body = Helpers.bodyBytes(request);
            request = Helpers.copy(request).method(request.method(), HttpRequest.BodyPublishers.ofByteArray(body)).build();
            SpeakeasyHTTPClient.log("Request body:\n" + new String(body, StandardCharsets.UTF_8));
        }
        return request;
    }

    private static HttpResponse<InputStream> logResponse(HttpResponse<InputStream> response, boolean logBody) throws IOException {
        response = Utils.cache(response);
        SpeakeasyHTTPClient.log("Received response: " + String.valueOf(response));
        SpeakeasyHTTPClient.log("Response headers: " + SpeakeasyHTTPClient.redactHeaders(response.headers()));
        if (logBody && response.headers().firstValue("Content-Type").filter(x -> x.equals("application/json") || x.equals("text/plain")).isPresent()) {
            SpeakeasyHTTPClient.log("Response body:\n" + Utils.toUtf8AndClose((InputStream)response.body()));
        }
        return response;
    }

    private static String redactHeaders(HttpHeaders headers) {
        return "{" + headers.map().entrySet().stream().map(entry -> {
            String value = redactedHeaders.contains(((String)entry.getKey()).toUpperCase(Locale.ENGLISH)) ? "[******]" : String.valueOf(entry.getValue());
            return (String)entry.getKey() + "=" + value;
        }).collect(Collectors.joining(", ")) + "}";
    }

    private static void log(String message) {
        logger.accept(message);
    }
}

