/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class ScopeDefinitionMetaItem {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="includes")
    private JsonNullable<? extends List<String>> includes;

    @JsonCreator
    public ScopeDefinitionMetaItem(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="includes") JsonNullable<? extends List<String>> includes) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(includes, "includes");
        this.name = name;
        this.description = description;
        this.includes = includes;
    }

    public ScopeDefinitionMetaItem(String name, String description) {
        this(name, description, (JsonNullable<? extends List<String>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String description() {
        return this.description;
    }

    @JsonIgnore
    public JsonNullable<List<String>> includes() {
        return this.includes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ScopeDefinitionMetaItem withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public ScopeDefinitionMetaItem withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    public ScopeDefinitionMetaItem withIncludes(List<String> includes) {
        Utils.checkNotNull(includes, "includes");
        this.includes = JsonNullable.of(includes);
        return this;
    }

    public ScopeDefinitionMetaItem withIncludes(JsonNullable<? extends List<String>> includes) {
        Utils.checkNotNull(includes, "includes");
        this.includes = includes;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeDefinitionMetaItem other = (ScopeDefinitionMetaItem)o;
        return Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.description, other.description) && Utils.enhancedDeepEquals(this.includes, other.includes);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.name, this.description, this.includes);
    }

    public String toString() {
        return Utils.toString(ScopeDefinitionMetaItem.class, "name", this.name, "description", this.description, "includes", this.includes);
    }

    public static final class Builder {
        private String name;
        private String description;
        private JsonNullable<? extends List<String>> includes = JsonNullable.undefined();

        private Builder() {
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        public Builder includes(List<String> includes) {
            Utils.checkNotNull(includes, "includes");
            this.includes = JsonNullable.of(includes);
            return this;
        }

        public Builder includes(JsonNullable<? extends List<String>> includes) {
            Utils.checkNotNull(includes, "includes");
            this.includes = includes;
            return this;
        }

        public ScopeDefinitionMetaItem build() {
            return new ScopeDefinitionMetaItem(this.name, this.description, this.includes);
        }
    }
}

