/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TaskValue {
    public static final TaskValue ACTION = new TaskValue("action");
    public static final TaskValue REVIEW = new TaskValue("review");
    public static final TaskValue ACKNOWLEDGMENT = new TaskValue("acknowledgment");
    public static final TaskValue EDIT = new TaskValue("edit");
    public static final TaskValue APPROVE = new TaskValue("approve");
    public static final TaskValue UNMAPPED_VALUE = new TaskValue("unmapped_value");
    private static final Map<String, TaskValue> values = TaskValue.createValuesMap();
    private static final Map<String, TaskValueEnum> enums = TaskValue.createEnumsMap();
    private final String value;

    private TaskValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static TaskValue of(String value) {
        Class<TaskValue> clazz = TaskValue.class;
        synchronized (TaskValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TaskValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<TaskValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskValue other = (TaskValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TaskValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskValue[] values() {
        Class<TaskValue> clazz = TaskValue.class;
        synchronized (TaskValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TaskValue[0]);
        }
    }

    private static final Map<String, TaskValue> createValuesMap() {
        LinkedHashMap<String, TaskValue> map = new LinkedHashMap<String, TaskValue>();
        map.put("action", ACTION);
        map.put("review", REVIEW);
        map.put("acknowledgment", ACKNOWLEDGMENT);
        map.put("edit", EDIT);
        map.put("approve", APPROVE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TaskValueEnum> createEnumsMap() {
        HashMap<String, TaskValueEnum> map = new HashMap<String, TaskValueEnum>();
        map.put("action", TaskValueEnum.ACTION);
        map.put("review", TaskValueEnum.REVIEW);
        map.put("acknowledgment", TaskValueEnum.ACKNOWLEDGMENT);
        map.put("edit", TaskValueEnum.EDIT);
        map.put("approve", TaskValueEnum.APPROVE);
        map.put("unmapped_value", TaskValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TaskValueEnum {
        ACTION("action"),
        REVIEW("review"),
        ACKNOWLEDGMENT("acknowledgment"),
        EDIT("edit"),
        APPROVE("approve"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TaskValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

