/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TicketingTicketResultValue {
    public static final TicketingTicketResultValue LOWEST = new TicketingTicketResultValue("lowest");
    public static final TicketingTicketResultValue LOW = new TicketingTicketResultValue("low");
    public static final TicketingTicketResultValue MEDIUM = new TicketingTicketResultValue("medium");
    public static final TicketingTicketResultValue HIGH = new TicketingTicketResultValue("high");
    public static final TicketingTicketResultValue HIGHEST = new TicketingTicketResultValue("highest");
    public static final TicketingTicketResultValue UNMAPPED_VALUE = new TicketingTicketResultValue("unmapped_value");
    private static final Map<String, TicketingTicketResultValue> values = TicketingTicketResultValue.createValuesMap();
    private static final Map<String, TicketingTicketResultValueEnum> enums = TicketingTicketResultValue.createEnumsMap();
    private final String value;

    private TicketingTicketResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static TicketingTicketResultValue of(String value) {
        Class<TicketingTicketResultValue> clazz = TicketingTicketResultValue.class;
        synchronized (TicketingTicketResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TicketingTicketResultValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<TicketingTicketResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketingTicketResultValue other = (TicketingTicketResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TicketingTicketResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TicketingTicketResultValue[] values() {
        Class<TicketingTicketResultValue> clazz = TicketingTicketResultValue.class;
        synchronized (TicketingTicketResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TicketingTicketResultValue[0]);
        }
    }

    private static final Map<String, TicketingTicketResultValue> createValuesMap() {
        LinkedHashMap<String, TicketingTicketResultValue> map = new LinkedHashMap<String, TicketingTicketResultValue>();
        map.put("lowest", LOWEST);
        map.put("low", LOW);
        map.put("medium", MEDIUM);
        map.put("high", HIGH);
        map.put("highest", HIGHEST);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TicketingTicketResultValueEnum> createEnumsMap() {
        HashMap<String, TicketingTicketResultValueEnum> map = new HashMap<String, TicketingTicketResultValueEnum>();
        map.put("lowest", TicketingTicketResultValueEnum.LOWEST);
        map.put("low", TicketingTicketResultValueEnum.LOW);
        map.put("medium", TicketingTicketResultValueEnum.MEDIUM);
        map.put("high", TicketingTicketResultValueEnum.HIGH);
        map.put("highest", TicketingTicketResultValueEnum.HIGHEST);
        map.put("unmapped_value", TicketingTicketResultValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TicketingTicketResultValueEnum {
        LOWEST("lowest"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high"),
        HIGHEST("highest"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TicketingTicketResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

