/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TimeOffPolicyValue {
    public static final TimeOffPolicyValue SICK = new TimeOffPolicyValue("sick");
    public static final TimeOffPolicyValue UNMAPPED_VALUE = new TimeOffPolicyValue("unmapped_value");
    public static final TimeOffPolicyValue VACATION = new TimeOffPolicyValue("vacation");
    public static final TimeOffPolicyValue LONG_TERM_DISABILITY = new TimeOffPolicyValue("long_term_disability");
    public static final TimeOffPolicyValue SHORT_TERM_DISABILITY = new TimeOffPolicyValue("short_term_disability");
    public static final TimeOffPolicyValue ABSENT = new TimeOffPolicyValue("absent");
    public static final TimeOffPolicyValue COMP_TIME = new TimeOffPolicyValue("comp_time");
    public static final TimeOffPolicyValue TRAINING = new TimeOffPolicyValue("training");
    public static final TimeOffPolicyValue ANNUAL_LEAVE = new TimeOffPolicyValue("annual_leave");
    public static final TimeOffPolicyValue LEAVE_OF_ABSENCE = new TimeOffPolicyValue("leave_of_absence");
    public static final TimeOffPolicyValue BREAK = new TimeOffPolicyValue("break");
    public static final TimeOffPolicyValue CHILD_CARE_LEAVE = new TimeOffPolicyValue("child_care_leave");
    public static final TimeOffPolicyValue MATERNITY_LEAVE = new TimeOffPolicyValue("maternity_leave");
    public static final TimeOffPolicyValue JURY_DUTY = new TimeOffPolicyValue("jury_duty");
    public static final TimeOffPolicyValue SABBATICAL = new TimeOffPolicyValue("sabbatical");
    public static final TimeOffPolicyValue ACCIDENT = new TimeOffPolicyValue("accident");
    public static final TimeOffPolicyValue PAID = new TimeOffPolicyValue("paid");
    public static final TimeOffPolicyValue UNPAID = new TimeOffPolicyValue("unpaid");
    public static final TimeOffPolicyValue HOLIDAY = new TimeOffPolicyValue("holiday");
    public static final TimeOffPolicyValue PERSONAL = new TimeOffPolicyValue("personal");
    public static final TimeOffPolicyValue IN_LIEU = new TimeOffPolicyValue("in_lieu");
    public static final TimeOffPolicyValue BEREAVEMENT = new TimeOffPolicyValue("bereavement");
    public static final TimeOffPolicyValue OTHER = new TimeOffPolicyValue("other");
    private static final Map<String, TimeOffPolicyValue> values = TimeOffPolicyValue.createValuesMap();
    private static final Map<String, TimeOffPolicyValueEnum> enums = TimeOffPolicyValue.createEnumsMap();
    private final String value;

    private TimeOffPolicyValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static TimeOffPolicyValue of(String value) {
        Class<TimeOffPolicyValue> clazz = TimeOffPolicyValue.class;
        synchronized (TimeOffPolicyValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TimeOffPolicyValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<TimeOffPolicyValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOffPolicyValue other = (TimeOffPolicyValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TimeOffPolicyValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffPolicyValue[] values() {
        Class<TimeOffPolicyValue> clazz = TimeOffPolicyValue.class;
        synchronized (TimeOffPolicyValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TimeOffPolicyValue[0]);
        }
    }

    private static final Map<String, TimeOffPolicyValue> createValuesMap() {
        LinkedHashMap<String, TimeOffPolicyValue> map = new LinkedHashMap<String, TimeOffPolicyValue>();
        map.put("sick", SICK);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("vacation", VACATION);
        map.put("long_term_disability", LONG_TERM_DISABILITY);
        map.put("short_term_disability", SHORT_TERM_DISABILITY);
        map.put("absent", ABSENT);
        map.put("comp_time", COMP_TIME);
        map.put("training", TRAINING);
        map.put("annual_leave", ANNUAL_LEAVE);
        map.put("leave_of_absence", LEAVE_OF_ABSENCE);
        map.put("break", BREAK);
        map.put("child_care_leave", CHILD_CARE_LEAVE);
        map.put("maternity_leave", MATERNITY_LEAVE);
        map.put("jury_duty", JURY_DUTY);
        map.put("sabbatical", SABBATICAL);
        map.put("accident", ACCIDENT);
        map.put("paid", PAID);
        map.put("unpaid", UNPAID);
        map.put("holiday", HOLIDAY);
        map.put("personal", PERSONAL);
        map.put("in_lieu", IN_LIEU);
        map.put("bereavement", BEREAVEMENT);
        map.put("other", OTHER);
        return map;
    }

    private static final Map<String, TimeOffPolicyValueEnum> createEnumsMap() {
        HashMap<String, TimeOffPolicyValueEnum> map = new HashMap<String, TimeOffPolicyValueEnum>();
        map.put("sick", TimeOffPolicyValueEnum.SICK);
        map.put("unmapped_value", TimeOffPolicyValueEnum.UNMAPPED_VALUE);
        map.put("vacation", TimeOffPolicyValueEnum.VACATION);
        map.put("long_term_disability", TimeOffPolicyValueEnum.LONG_TERM_DISABILITY);
        map.put("short_term_disability", TimeOffPolicyValueEnum.SHORT_TERM_DISABILITY);
        map.put("absent", TimeOffPolicyValueEnum.ABSENT);
        map.put("comp_time", TimeOffPolicyValueEnum.COMP_TIME);
        map.put("training", TimeOffPolicyValueEnum.TRAINING);
        map.put("annual_leave", TimeOffPolicyValueEnum.ANNUAL_LEAVE);
        map.put("leave_of_absence", TimeOffPolicyValueEnum.LEAVE_OF_ABSENCE);
        map.put("break", TimeOffPolicyValueEnum.BREAK);
        map.put("child_care_leave", TimeOffPolicyValueEnum.CHILD_CARE_LEAVE);
        map.put("maternity_leave", TimeOffPolicyValueEnum.MATERNITY_LEAVE);
        map.put("jury_duty", TimeOffPolicyValueEnum.JURY_DUTY);
        map.put("sabbatical", TimeOffPolicyValueEnum.SABBATICAL);
        map.put("accident", TimeOffPolicyValueEnum.ACCIDENT);
        map.put("paid", TimeOffPolicyValueEnum.PAID);
        map.put("unpaid", TimeOffPolicyValueEnum.UNPAID);
        map.put("holiday", TimeOffPolicyValueEnum.HOLIDAY);
        map.put("personal", TimeOffPolicyValueEnum.PERSONAL);
        map.put("in_lieu", TimeOffPolicyValueEnum.IN_LIEU);
        map.put("bereavement", TimeOffPolicyValueEnum.BEREAVEMENT);
        map.put("other", TimeOffPolicyValueEnum.OTHER);
        return map;
    }

    public static enum TimeOffPolicyValueEnum {
        SICK("sick"),
        UNMAPPED_VALUE("unmapped_value"),
        VACATION("vacation"),
        LONG_TERM_DISABILITY("long_term_disability"),
        SHORT_TERM_DISABILITY("short_term_disability"),
        ABSENT("absent"),
        COMP_TIME("comp_time"),
        TRAINING("training"),
        ANNUAL_LEAVE("annual_leave"),
        LEAVE_OF_ABSENCE("leave_of_absence"),
        BREAK("break"),
        CHILD_CARE_LEAVE("child_care_leave"),
        MATERNITY_LEAVE("maternity_leave"),
        JURY_DUTY("jury_duty"),
        SABBATICAL("sabbatical"),
        ACCIDENT("accident"),
        PAID("paid"),
        UNPAID("unpaid"),
        HOLIDAY("holiday"),
        PERSONAL("personal"),
        IN_LIEU("in_lieu"),
        BEREAVEMENT("bereavement"),
        OTHER("other");

        private final String value;

        private TimeOffPolicyValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

