/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisInviteEmployeeRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class HrisInviteEmployeeRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private HrisInviteEmployeeRequestDto hrisInviteEmployeeRequestDto;

    @JsonCreator
    public HrisInviteEmployeeRequest(String xAccountId, String id, Optional<String> prefer, HrisInviteEmployeeRequestDto hrisInviteEmployeeRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(hrisInviteEmployeeRequestDto, "hrisInviteEmployeeRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.hrisInviteEmployeeRequestDto = hrisInviteEmployeeRequestDto;
    }

    public HrisInviteEmployeeRequest(String xAccountId, String id, HrisInviteEmployeeRequestDto hrisInviteEmployeeRequestDto) {
        this(xAccountId, id, Optional.empty(), hrisInviteEmployeeRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public HrisInviteEmployeeRequestDto hrisInviteEmployeeRequestDto() {
        return this.hrisInviteEmployeeRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisInviteEmployeeRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisInviteEmployeeRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisInviteEmployeeRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public HrisInviteEmployeeRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisInviteEmployeeRequest withHrisInviteEmployeeRequestDto(HrisInviteEmployeeRequestDto hrisInviteEmployeeRequestDto) {
        Utils.checkNotNull(hrisInviteEmployeeRequestDto, "hrisInviteEmployeeRequestDto");
        this.hrisInviteEmployeeRequestDto = hrisInviteEmployeeRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisInviteEmployeeRequest other = (HrisInviteEmployeeRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.hrisInviteEmployeeRequestDto, other.hrisInviteEmployeeRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.hrisInviteEmployeeRequestDto);
    }

    public String toString() {
        return Utils.toString(HrisInviteEmployeeRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "hrisInviteEmployeeRequestDto", this.hrisInviteEmployeeRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private HrisInviteEmployeeRequestDto hrisInviteEmployeeRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder hrisInviteEmployeeRequestDto(HrisInviteEmployeeRequestDto hrisInviteEmployeeRequestDto) {
            Utils.checkNotNull(hrisInviteEmployeeRequestDto, "hrisInviteEmployeeRequestDto");
            this.hrisInviteEmployeeRequestDto = hrisInviteEmployeeRequestDto;
            return this;
        }

        public HrisInviteEmployeeRequest build() {
            return new HrisInviteEmployeeRequest(this.xAccountId, this.id, this.prefer, this.hrisInviteEmployeeRequestDto);
        }
    }
}

