/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LmsBatchUpsertContentRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class LmsBatchUpsertContentRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto;

    @JsonCreator
    public LmsBatchUpsertContentRequest(String xAccountId, Optional<String> prefer, LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(lmsBatchUpsertContentRequestDto, "lmsBatchUpsertContentRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.lmsBatchUpsertContentRequestDto = lmsBatchUpsertContentRequestDto;
    }

    public LmsBatchUpsertContentRequest(String xAccountId, LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto) {
        this(xAccountId, Optional.empty(), lmsBatchUpsertContentRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto() {
        return this.lmsBatchUpsertContentRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LmsBatchUpsertContentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsBatchUpsertContentRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public LmsBatchUpsertContentRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public LmsBatchUpsertContentRequest withLmsBatchUpsertContentRequestDto(LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto) {
        Utils.checkNotNull(lmsBatchUpsertContentRequestDto, "lmsBatchUpsertContentRequestDto");
        this.lmsBatchUpsertContentRequestDto = lmsBatchUpsertContentRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsBatchUpsertContentRequest other = (LmsBatchUpsertContentRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.lmsBatchUpsertContentRequestDto, other.lmsBatchUpsertContentRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.lmsBatchUpsertContentRequestDto);
    }

    public String toString() {
        return Utils.toString(LmsBatchUpsertContentRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "lmsBatchUpsertContentRequestDto", this.lmsBatchUpsertContentRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder lmsBatchUpsertContentRequestDto(LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto) {
            Utils.checkNotNull(lmsBatchUpsertContentRequestDto, "lmsBatchUpsertContentRequestDto");
            this.lmsBatchUpsertContentRequestDto = lmsBatchUpsertContentRequestDto;
            return this;
        }

        public LmsBatchUpsertContentRequest build() {
            return new LmsBatchUpsertContentRequest(this.xAccountId, this.prefer, this.lmsBatchUpsertContentRequestDto);
        }
    }
}

