/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreateSmsTemplateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class MarketingUpdateSmsTemplateRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto;

    @JsonCreator
    public MarketingUpdateSmsTemplateRequest(String xAccountId, String id, Optional<String> prefer, MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(marketingCreateSmsTemplateRequestDto, "marketingCreateSmsTemplateRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.marketingCreateSmsTemplateRequestDto = marketingCreateSmsTemplateRequestDto;
    }

    public MarketingUpdateSmsTemplateRequest(String xAccountId, String id, MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto) {
        this(xAccountId, id, Optional.empty(), marketingCreateSmsTemplateRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto() {
        return this.marketingCreateSmsTemplateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MarketingUpdateSmsTemplateRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MarketingUpdateSmsTemplateRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public MarketingUpdateSmsTemplateRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public MarketingUpdateSmsTemplateRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MarketingUpdateSmsTemplateRequest withMarketingCreateSmsTemplateRequestDto(MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto) {
        Utils.checkNotNull(marketingCreateSmsTemplateRequestDto, "marketingCreateSmsTemplateRequestDto");
        this.marketingCreateSmsTemplateRequestDto = marketingCreateSmsTemplateRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingUpdateSmsTemplateRequest other = (MarketingUpdateSmsTemplateRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.marketingCreateSmsTemplateRequestDto, other.marketingCreateSmsTemplateRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.marketingCreateSmsTemplateRequestDto);
    }

    public String toString() {
        return Utils.toString(MarketingUpdateSmsTemplateRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "marketingCreateSmsTemplateRequestDto", this.marketingCreateSmsTemplateRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder marketingCreateSmsTemplateRequestDto(MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto) {
            Utils.checkNotNull(marketingCreateSmsTemplateRequestDto, "marketingCreateSmsTemplateRequestDto");
            this.marketingCreateSmsTemplateRequestDto = marketingCreateSmsTemplateRequestDto;
            return this;
        }

        public MarketingUpdateSmsTemplateRequest build() {
            return new MarketingUpdateSmsTemplateRequest(this.xAccountId, this.id, this.prefer, this.marketingCreateSmsTemplateRequestDto);
        }
    }
}

