/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AccountingJournalCreateRequestDto;
import com.stackone.stackone_client_java.models.operations.AccountingCreateCompanyJournalRequest;
import com.stackone.stackone_client_java.models.operations.async.AccountingCreateCompanyJournalResponse;
import com.stackone.stackone_client_java.operations.AccountingCreateCompanyJournal;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AccountingCreateCompanyJournalRequestBuilder {
    private String xAccountId;
    private String id;
    private Optional<String> prefer = Optional.empty();
    private AccountingJournalCreateRequestDto accountingJournalCreateRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AccountingCreateCompanyJournalRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AccountingCreateCompanyJournalRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AccountingCreateCompanyJournalRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AccountingCreateCompanyJournalRequestBuilder prefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.of(prefer);
        return this;
    }

    public AccountingCreateCompanyJournalRequestBuilder prefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AccountingCreateCompanyJournalRequestBuilder accountingJournalCreateRequestDto(AccountingJournalCreateRequestDto accountingJournalCreateRequestDto) {
        Utils.checkNotNull(accountingJournalCreateRequestDto, "accountingJournalCreateRequestDto");
        this.accountingJournalCreateRequestDto = accountingJournalCreateRequestDto;
        return this;
    }

    public AccountingCreateCompanyJournalRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AccountingCreateCompanyJournalRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private AccountingCreateCompanyJournalRequest buildRequest() {
        AccountingCreateCompanyJournalRequest request = new AccountingCreateCompanyJournalRequest(this.xAccountId, this.id, this.prefer, this.accountingJournalCreateRequestDto);
        return request;
    }

    public CompletableFuture<AccountingCreateCompanyJournalResponse> call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AccountingCreateCompanyJournal.Async operation = new AccountingCreateCompanyJournal.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        AccountingCreateCompanyJournalRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

