/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AssessmentPackagePaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListAssessmentsPackagesResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends AssessmentPackagePaginated> assessmentPackagePaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListAssessmentsPackagesResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends AssessmentPackagePaginated> assessmentPackagePaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(assessmentPackagePaginated, "assessmentPackagePaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.assessmentPackagePaginated = assessmentPackagePaginated;
        this.headers = headers;
    }

    public AtsListAssessmentsPackagesResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AssessmentPackagePaginated> assessmentPackagePaginated() {
        return this.assessmentPackagePaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsListAssessmentsPackagesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListAssessmentsPackagesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListAssessmentsPackagesResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListAssessmentsPackagesResponse withAssessmentPackagePaginated(AssessmentPackagePaginated assessmentPackagePaginated) {
        Utils.checkNotNull(assessmentPackagePaginated, "assessmentPackagePaginated");
        this.assessmentPackagePaginated = Optional.ofNullable(assessmentPackagePaginated);
        return this;
    }

    public AtsListAssessmentsPackagesResponse withAssessmentPackagePaginated(Optional<? extends AssessmentPackagePaginated> assessmentPackagePaginated) {
        Utils.checkNotNull(assessmentPackagePaginated, "assessmentPackagePaginated");
        this.assessmentPackagePaginated = assessmentPackagePaginated;
        return this;
    }

    public AtsListAssessmentsPackagesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListAssessmentsPackagesResponse other = (AtsListAssessmentsPackagesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.assessmentPackagePaginated, other.assessmentPackagePaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.assessmentPackagePaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListAssessmentsPackagesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "assessmentPackagePaginated", this.assessmentPackagePaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends AssessmentPackagePaginated> assessmentPackagePaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder assessmentPackagePaginated(AssessmentPackagePaginated assessmentPackagePaginated) {
            Utils.checkNotNull(assessmentPackagePaginated, "assessmentPackagePaginated");
            this.assessmentPackagePaginated = Optional.ofNullable(assessmentPackagePaginated);
            return this;
        }

        public Builder assessmentPackagePaginated(Optional<? extends AssessmentPackagePaginated> assessmentPackagePaginated) {
            Utils.checkNotNull(assessmentPackagePaginated, "assessmentPackagePaginated");
            this.assessmentPackagePaginated = assessmentPackagePaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListAssessmentsPackagesResponse build() {
            return new AtsListAssessmentsPackagesResponse(this.contentType, this.statusCode, this.rawResponse, this.assessmentPackagePaginated, this.headers);
        }
    }
}

