/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.operations;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.SmsTemplateResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MarketingGetSmsTemplateResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The SMS template with the given identifier was retrieved.
     */
    private Optional<? extends SmsTemplateResult> smsTemplateResult;

    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingGetSmsTemplateResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends SmsTemplateResult> smsTemplateResult,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(smsTemplateResult, "smsTemplateResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.smsTemplateResult = smsTemplateResult;
        this.headers = headers;
    }
    
    public MarketingGetSmsTemplateResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The SMS template with the given identifier was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<SmsTemplateResult> smsTemplateResult() {
        return (Optional<SmsTemplateResult>) smsTemplateResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * HTTP response content type for this operation
     */
    public MarketingGetSmsTemplateResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public MarketingGetSmsTemplateResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public MarketingGetSmsTemplateResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The SMS template with the given identifier was retrieved.
     */
    public MarketingGetSmsTemplateResponse withSmsTemplateResult(SmsTemplateResult smsTemplateResult) {
        Utils.checkNotNull(smsTemplateResult, "smsTemplateResult");
        this.smsTemplateResult = Optional.ofNullable(smsTemplateResult);
        return this;
    }

    /**
     * The SMS template with the given identifier was retrieved.
     */
    public MarketingGetSmsTemplateResponse withSmsTemplateResult(Optional<? extends SmsTemplateResult> smsTemplateResult) {
        Utils.checkNotNull(smsTemplateResult, "smsTemplateResult");
        this.smsTemplateResult = smsTemplateResult;
        return this;
    }

    public MarketingGetSmsTemplateResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MarketingGetSmsTemplateResponse other = (MarketingGetSmsTemplateResponse) o;
        return 
            Objects.deepEquals(this.contentType, other.contentType) &&
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.rawResponse, other.rawResponse) &&
            Objects.deepEquals(this.smsTemplateResult, other.smsTemplateResult) &&
            Objects.deepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            contentType,
            statusCode,
            rawResponse,
            smsTemplateResult,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MarketingGetSmsTemplateResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "smsTemplateResult", smsTemplateResult,
                "headers", headers);
    }
    
    public final static class Builder {
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends SmsTemplateResult> smsTemplateResult = Optional.empty();
 
        private Map<String, List<String>> headers;  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The SMS template with the given identifier was retrieved.
         */
        public Builder smsTemplateResult(SmsTemplateResult smsTemplateResult) {
            Utils.checkNotNull(smsTemplateResult, "smsTemplateResult");
            this.smsTemplateResult = Optional.ofNullable(smsTemplateResult);
            return this;
        }

        /**
         * The SMS template with the given identifier was retrieved.
         */
        public Builder smsTemplateResult(Optional<? extends SmsTemplateResult> smsTemplateResult) {
            Utils.checkNotNull(smsTemplateResult, "smsTemplateResult");
            this.smsTemplateResult = smsTemplateResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }
        
        public MarketingGetSmsTemplateResponse build() {
            return new MarketingGetSmsTemplateResponse(
                contentType,
                statusCode,
                rawResponse,
                smsTemplateResult,
                headers);
        }
    }
}

