/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.LinkedAccount;
import com.stackone.stackone_client_java.models.components.LinkedAccountMeta;
import com.stackone.stackone_client_java.models.components.PatchAccountExternalDto;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountResponse;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoResponse;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountResponse;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsResponse;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountResponse;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.SerializedBody;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class Accounts
implements SDKMethodInterfaces.MethodCallStackoneListLinkedAccounts,
SDKMethodInterfaces.MethodCallStackoneGetAccount,
SDKMethodInterfaces.MethodCallStackoneDeleteAccount,
SDKMethodInterfaces.MethodCallStackoneUpdateAccount,
SDKMethodInterfaces.MethodCallStackoneGetAccountMetaInfo {
    private final SDKConfiguration sdkConfiguration;

    Accounts(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneListLinkedAccountsRequestBuilder listLinkedAccounts() {
        return new StackoneListLinkedAccountsRequestBuilder(this);
    }

    public StackoneListLinkedAccountsResponse listLinkedAccounts(StackoneListLinkedAccountsRequest request) throws Exception {
        return this.listLinkedAccounts(request, Optional.empty());
    }

    @Override
    public StackoneListLinkedAccountsResponse listLinkedAccounts(StackoneListLinkedAccountsRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/accounts");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(StackoneListLinkedAccountsRequest.class, request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("stackone_list_linked_accounts", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("stackone_list_linked_accounts", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("stackone_list_linked_accounts", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        StackoneListLinkedAccountsResponse.Builder _resBuilder = StackoneListLinkedAccountsResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        StackoneListLinkedAccountsResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                List _out = (List)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<List<LinkedAccount>>(){});
                _res.withLinkedAccounts(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public StackoneGetAccountRequestBuilder getAccount() {
        return new StackoneGetAccountRequestBuilder(this);
    }

    public StackoneGetAccountResponse getAccount(String id) throws Exception {
        return this.getAccount(id, Optional.empty());
    }

    @Override
    public StackoneGetAccountResponse getAccount(String id, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        StackoneGetAccountRequest request = StackoneGetAccountRequest.builder().id(id).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(StackoneGetAccountRequest.class, _baseUrl, "/accounts/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("stackone_get_account", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("stackone_get_account", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("stackone_get_account", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        StackoneGetAccountResponse.Builder _resBuilder = StackoneGetAccountResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        StackoneGetAccountResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                LinkedAccount _out = (LinkedAccount)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<LinkedAccount>(){});
                _res.withLinkedAccount(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public StackoneDeleteAccountRequestBuilder deleteAccount() {
        return new StackoneDeleteAccountRequestBuilder(this);
    }

    public StackoneDeleteAccountResponse deleteAccount(String id) throws Exception {
        return this.deleteAccount(id, Optional.empty());
    }

    @Override
    public StackoneDeleteAccountResponse deleteAccount(String id, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        StackoneDeleteAccountRequest request = StackoneDeleteAccountRequest.builder().id(id).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(StackoneDeleteAccountRequest.class, _baseUrl, "/accounts/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "DELETE");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("stackone_delete_account", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("stackone_delete_account", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("stackone_delete_account", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        StackoneDeleteAccountResponse.Builder _resBuilder = StackoneDeleteAccountResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        StackoneDeleteAccountResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                LinkedAccount _out = (LinkedAccount)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<LinkedAccount>(){});
                _res.withLinkedAccount(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "404", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public StackoneUpdateAccountRequestBuilder updateAccount() {
        return new StackoneUpdateAccountRequestBuilder(this);
    }

    public StackoneUpdateAccountResponse updateAccount(String id, PatchAccountExternalDto patchAccountExternalDto) throws Exception {
        return this.updateAccount(id, patchAccountExternalDto, Optional.empty());
    }

    @Override
    public StackoneUpdateAccountResponse updateAccount(String id, PatchAccountExternalDto patchAccountExternalDto, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        StackoneUpdateAccountRequest request = StackoneUpdateAccountRequest.builder().id(id).patchAccountExternalDto(patchAccountExternalDto).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(StackoneUpdateAccountRequest.class, _baseUrl, "/accounts/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "PATCH");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "patchAccountExternalDto", "json", false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("stackone_update_account", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("stackone_update_account", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("stackone_update_account", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        StackoneUpdateAccountResponse.Builder _resBuilder = StackoneUpdateAccountResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        StackoneUpdateAccountResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                LinkedAccount _out = (LinkedAccount)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<LinkedAccount>(){});
                _res.withLinkedAccount(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public StackoneGetAccountMetaInfoRequestBuilder getAccountMetaInfo() {
        return new StackoneGetAccountMetaInfoRequestBuilder(this);
    }

    public StackoneGetAccountMetaInfoResponse getAccountMetaInfo(String id) throws Exception {
        return this.getAccountMetaInfo(id, Optional.empty());
    }

    @Override
    public StackoneGetAccountMetaInfoResponse getAccountMetaInfo(String id, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        StackoneGetAccountMetaInfoRequest request = StackoneGetAccountMetaInfoRequest.builder().id(id).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(StackoneGetAccountMetaInfoRequest.class, _baseUrl, "/accounts/{id}/meta", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("stackone_get_account_meta_info", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("stackone_get_account_meta_info", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("stackone_get_account_meta_info", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        StackoneGetAccountMetaInfoResponse.Builder _resBuilder = StackoneGetAccountMetaInfoResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        StackoneGetAccountMetaInfoResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                LinkedAccountMeta _out = (LinkedAccountMeta)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<LinkedAccountMeta>(){});
                _res.withLinkedAccountMeta(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "404", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }
}

