/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class IamPermissionType {

    /**
     * The type of the permission, e.g. read, read_write, delete, etc.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends IamPermissionValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends IamPermissionSourceValue> sourceValue;

    @JsonCreator
    public IamPermissionType(
            @JsonProperty("value") JsonNullable<? extends IamPermissionValue> value,
            @JsonProperty("source_value") JsonNullable<? extends IamPermissionSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public IamPermissionType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of the permission, e.g. read, read_write, delete, etc.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IamPermissionValue> value() {
        return (JsonNullable<IamPermissionValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IamPermissionSourceValue> sourceValue() {
        return (JsonNullable<IamPermissionSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The type of the permission, e.g. read, read_write, delete, etc.
     */
    public IamPermissionType withValue(IamPermissionValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of the permission, e.g. read, read_write, delete, etc.
     */
    public IamPermissionType withValue(JsonNullable<? extends IamPermissionValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public IamPermissionType withSourceValue(IamPermissionSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public IamPermissionType withSourceValue(JsonNullable<? extends IamPermissionSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IamPermissionType other = (IamPermissionType) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IamPermissionType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends IamPermissionValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends IamPermissionSourceValue> sourceValue = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The type of the permission, e.g. read, read_write, delete, etc.
         */
        public Builder value(IamPermissionValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of the permission, e.g. read, read_write, delete, etc.
         */
        public Builder value(JsonNullable<? extends IamPermissionValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(IamPermissionSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends IamPermissionSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public IamPermissionType build() {
            return new IamPermissionType(
                value,
                sourceValue);
        }
    }
}

