/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class TimeOffValue {
    public static final TimeOffValue APPROVED = new TimeOffValue("approved");
    public static final TimeOffValue CANCELLED = new TimeOffValue("cancelled");
    public static final TimeOffValue REJECTED = new TimeOffValue("rejected");
    public static final TimeOffValue PENDING = new TimeOffValue("pending");
    public static final TimeOffValue DELETED = new TimeOffValue("deleted");
    public static final TimeOffValue DRAFT = new TimeOffValue("draft");
    public static final TimeOffValue UNMAPPED_VALUE = new TimeOffValue("unmapped_value");
    private static final Map<String, TimeOffValue> values = TimeOffValue.createValuesMap();
    private static final Map<String, TimeOffValueEnum> enums = TimeOffValue.createEnumsMap();
    private final String value;

    private TimeOffValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffValue of(String value) {
        Class<TimeOffValue> clazz = TimeOffValue.class;
        synchronized (TimeOffValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TimeOffValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<TimeOffValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOffValue other = (TimeOffValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TimeOffValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffValue[] values() {
        Class<TimeOffValue> clazz = TimeOffValue.class;
        synchronized (TimeOffValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TimeOffValue[0]);
        }
    }

    private static final Map<String, TimeOffValue> createValuesMap() {
        LinkedHashMap<String, TimeOffValue> map = new LinkedHashMap<String, TimeOffValue>();
        map.put("approved", APPROVED);
        map.put("cancelled", CANCELLED);
        map.put("rejected", REJECTED);
        map.put("pending", PENDING);
        map.put("deleted", DELETED);
        map.put("draft", DRAFT);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeOffValueEnum> createEnumsMap() {
        HashMap<String, TimeOffValueEnum> map = new HashMap<String, TimeOffValueEnum>();
        map.put("approved", TimeOffValueEnum.APPROVED);
        map.put("cancelled", TimeOffValueEnum.CANCELLED);
        map.put("rejected", TimeOffValueEnum.REJECTED);
        map.put("pending", TimeOffValueEnum.PENDING);
        map.put("deleted", TimeOffValueEnum.DELETED);
        map.put("draft", TimeOffValueEnum.DRAFT);
        map.put("unmapped_value", TimeOffValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TimeOffValueEnum {
        APPROVED("approved"),
        CANCELLED("cancelled"),
        REJECTED("rejected"),
        PENDING("pending"),
        DELETED("deleted"),
        DRAFT("draft"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TimeOffValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<TimeOffValue> {
        protected _Deserializer() {
            super(TimeOffValue.class);
        }

        public TimeOffValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return TimeOffValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<TimeOffValue> {
        protected _Serializer() {
            super(TimeOffValue.class);
        }

        public void serialize(TimeOffValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

