/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.EmploymentDurationUnit;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class WorkTime {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="duration")
    private JsonNullable<String> duration;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="duration_unit")
    private JsonNullable<? extends EmploymentDurationUnit> durationUnit;

    @JsonCreator
    public WorkTime(@JsonProperty(value="duration") JsonNullable<String> duration, @JsonProperty(value="duration_unit") JsonNullable<? extends EmploymentDurationUnit> durationUnit) {
        Utils.checkNotNull(duration, "duration");
        Utils.checkNotNull(durationUnit, "durationUnit");
        this.duration = duration;
        this.durationUnit = durationUnit;
    }

    public WorkTime() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends EmploymentDurationUnit>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> duration() {
        return this.duration;
    }

    @JsonIgnore
    public JsonNullable<EmploymentDurationUnit> durationUnit() {
        return this.durationUnit;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public WorkTime withDuration(String duration) {
        Utils.checkNotNull(duration, "duration");
        this.duration = JsonNullable.of((Object)duration);
        return this;
    }

    public WorkTime withDuration(JsonNullable<String> duration) {
        Utils.checkNotNull(duration, "duration");
        this.duration = duration;
        return this;
    }

    public WorkTime withDurationUnit(EmploymentDurationUnit durationUnit) {
        Utils.checkNotNull(durationUnit, "durationUnit");
        this.durationUnit = JsonNullable.of((Object)durationUnit);
        return this;
    }

    public WorkTime withDurationUnit(JsonNullable<? extends EmploymentDurationUnit> durationUnit) {
        Utils.checkNotNull(durationUnit, "durationUnit");
        this.durationUnit = durationUnit;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkTime other = (WorkTime)o;
        return Objects.deepEquals(this.duration, other.duration) && Objects.deepEquals(this.durationUnit, other.durationUnit);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.durationUnit);
    }

    public String toString() {
        return Utils.toString(WorkTime.class, "duration", this.duration, "durationUnit", this.durationUnit);
    }

    public static final class Builder {
        private JsonNullable<String> duration = JsonNullable.undefined();
        private JsonNullable<? extends EmploymentDurationUnit> durationUnit = JsonNullable.undefined();

        private Builder() {
        }

        public Builder duration(String duration) {
            Utils.checkNotNull(duration, "duration");
            this.duration = JsonNullable.of((Object)duration);
            return this;
        }

        public Builder duration(JsonNullable<String> duration) {
            Utils.checkNotNull(duration, "duration");
            this.duration = duration;
            return this;
        }

        public Builder durationUnit(EmploymentDurationUnit durationUnit) {
            Utils.checkNotNull(durationUnit, "durationUnit");
            this.durationUnit = JsonNullable.of((Object)durationUnit);
            return this;
        }

        public Builder durationUnit(JsonNullable<? extends EmploymentDurationUnit> durationUnit) {
            Utils.checkNotNull(durationUnit, "durationUnit");
            this.durationUnit = durationUnit;
            return this;
        }

        public WorkTime build() {
            return new WorkTime(this.duration, this.durationUnit);
        }
    }
}

