/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CustomFieldDefinitionsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class AtsListJobCustomFieldDefinitionsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<AtsListJobCustomFieldDefinitionsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public AtsListJobCustomFieldDefinitionsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.customFieldDefinitionsPaginated = customFieldDefinitionsPaginated;
        this.headers = headers;
    }

    public AtsListJobCustomFieldDefinitionsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated() {
        return this.customFieldDefinitionsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<AtsListJobCustomFieldDefinitionsResponse> next() throws Exception {
        return this.next.call();
    }

    private AtsListJobCustomFieldDefinitionsResponse withNext(Callable<Optional<AtsListJobCustomFieldDefinitionsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsListJobCustomFieldDefinitionsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListJobCustomFieldDefinitionsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListJobCustomFieldDefinitionsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListJobCustomFieldDefinitionsResponse withCustomFieldDefinitionsPaginated(CustomFieldDefinitionsPaginated customFieldDefinitionsPaginated) {
        Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
        this.customFieldDefinitionsPaginated = Optional.ofNullable(customFieldDefinitionsPaginated);
        return this;
    }

    public AtsListJobCustomFieldDefinitionsResponse withCustomFieldDefinitionsPaginated(Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated) {
        Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
        this.customFieldDefinitionsPaginated = customFieldDefinitionsPaginated;
        return this;
    }

    public AtsListJobCustomFieldDefinitionsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListJobCustomFieldDefinitionsResponse other = (AtsListJobCustomFieldDefinitionsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.customFieldDefinitionsPaginated, other.customFieldDefinitionsPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.customFieldDefinitionsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListJobCustomFieldDefinitionsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "customFieldDefinitionsPaginated", this.customFieldDefinitionsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<AtsListJobCustomFieldDefinitionsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder customFieldDefinitionsPaginated(CustomFieldDefinitionsPaginated customFieldDefinitionsPaginated) {
            Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
            this.customFieldDefinitionsPaginated = Optional.ofNullable(customFieldDefinitionsPaginated);
            return this;
        }

        public Builder customFieldDefinitionsPaginated(Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated) {
            Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
            this.customFieldDefinitionsPaginated = customFieldDefinitionsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<AtsListJobCustomFieldDefinitionsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public AtsListJobCustomFieldDefinitionsResponse build() {
            return new AtsListJobCustomFieldDefinitionsResponse(this.contentType, this.statusCode, this.rawResponse, this.customFieldDefinitionsPaginated, this.headers).withNext(this.next);
        }
    }
}

