/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.components.ConnectSessionAuthenticate;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.models.operations.StackoneAuthenticateConnectSessionResponse;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneAuthenticateConnectSessionRequestBuilder {
    private ConnectSessionAuthenticate request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallStackoneAuthenticateConnectSession sdk;

    public StackoneAuthenticateConnectSessionRequestBuilder(SDKMethodInterfaces.MethodCallStackoneAuthenticateConnectSession sdk) {
        this.sdk = sdk;
    }

    public StackoneAuthenticateConnectSessionRequestBuilder request(ConnectSessionAuthenticate request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public StackoneAuthenticateConnectSessionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneAuthenticateConnectSessionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public StackoneAuthenticateConnectSessionResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.authenticateConnectSession(this.request, options);
    }
}

