/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.AnswerType;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class Answer {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private JsonNullable<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="remote_id")
    private JsonNullable<String> remoteId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="type")
    private JsonNullable<? extends AnswerType> type;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="values")
    private JsonNullable<? extends List<String>> values;

    @JsonCreator
    public Answer(@JsonProperty(value="id") JsonNullable<String> id, @JsonProperty(value="remote_id") JsonNullable<String> remoteId, @JsonProperty(value="type") JsonNullable<? extends AnswerType> type, @JsonProperty(value="values") JsonNullable<? extends List<String>> values) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(values, "values");
        this.id = id;
        this.remoteId = remoteId;
        this.type = type;
        this.values = values;
    }

    public Answer() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends AnswerType>)JsonNullable.undefined(), (JsonNullable<? extends List<String>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return this.remoteId;
    }

    @JsonIgnore
    public JsonNullable<AnswerType> type() {
        return this.type;
    }

    @JsonIgnore
    public JsonNullable<List<String>> values() {
        return this.values;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Answer withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    public Answer withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Answer withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of((Object)remoteId);
        return this;
    }

    public Answer withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public Answer withType(AnswerType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of((Object)type);
        return this;
    }

    public Answer withType(JsonNullable<? extends AnswerType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public Answer withValues(List<String> values) {
        Utils.checkNotNull(values, "values");
        this.values = JsonNullable.of(values);
        return this;
    }

    public Answer withValues(JsonNullable<? extends List<String>> values) {
        Utils.checkNotNull(values, "values");
        this.values = values;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Answer other = (Answer)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.remoteId, other.remoteId) && Utils.enhancedDeepEquals(this.type, other.type) && Utils.enhancedDeepEquals(this.values, other.values);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.remoteId, this.type, this.values);
    }

    public String toString() {
        return Utils.toString(Answer.class, "id", this.id, "remoteId", this.remoteId, "type", this.type, "values", this.values);
    }

    public static final class Builder {
        private JsonNullable<String> id = JsonNullable.undefined();
        private JsonNullable<String> remoteId = JsonNullable.undefined();
        private JsonNullable<? extends AnswerType> type = JsonNullable.undefined();
        private JsonNullable<? extends List<String>> values = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of((Object)id);
            return this;
        }

        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of((Object)remoteId);
            return this;
        }

        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder type(AnswerType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of((Object)type);
            return this;
        }

        public Builder type(JsonNullable<? extends AnswerType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder values(List<String> values) {
            Utils.checkNotNull(values, "values");
            this.values = JsonNullable.of(values);
            return this;
        }

        public Builder values(JsonNullable<? extends List<String>> values) {
            Utils.checkNotNull(values, "values");
            this.values = values;
            return this;
        }

        public Answer build() {
            return new Answer(this.id, this.remoteId, this.type, this.values);
        }
    }
}

