/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CreateBackgroundCheckOrderResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsOrderBackgroundCheckRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends CreateBackgroundCheckOrderResult> createBackgroundCheckOrderResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsOrderBackgroundCheckRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends CreateBackgroundCheckOrderResult> createBackgroundCheckOrderResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(createBackgroundCheckOrderResult, "createBackgroundCheckOrderResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.createBackgroundCheckOrderResult = createBackgroundCheckOrderResult;
        this.headers = headers;
    }

    public AtsOrderBackgroundCheckRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CreateBackgroundCheckOrderResult> createBackgroundCheckOrderResult() {
        return this.createBackgroundCheckOrderResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsOrderBackgroundCheckRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsOrderBackgroundCheckRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsOrderBackgroundCheckRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsOrderBackgroundCheckRequestResponse withCreateBackgroundCheckOrderResult(CreateBackgroundCheckOrderResult createBackgroundCheckOrderResult) {
        Utils.checkNotNull(createBackgroundCheckOrderResult, "createBackgroundCheckOrderResult");
        this.createBackgroundCheckOrderResult = Optional.ofNullable(createBackgroundCheckOrderResult);
        return this;
    }

    public AtsOrderBackgroundCheckRequestResponse withCreateBackgroundCheckOrderResult(Optional<? extends CreateBackgroundCheckOrderResult> createBackgroundCheckOrderResult) {
        Utils.checkNotNull(createBackgroundCheckOrderResult, "createBackgroundCheckOrderResult");
        this.createBackgroundCheckOrderResult = createBackgroundCheckOrderResult;
        return this;
    }

    public AtsOrderBackgroundCheckRequestResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsOrderBackgroundCheckRequestResponse other = (AtsOrderBackgroundCheckRequestResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.createBackgroundCheckOrderResult, other.createBackgroundCheckOrderResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.createBackgroundCheckOrderResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsOrderBackgroundCheckRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "createBackgroundCheckOrderResult", this.createBackgroundCheckOrderResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends CreateBackgroundCheckOrderResult> createBackgroundCheckOrderResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder createBackgroundCheckOrderResult(CreateBackgroundCheckOrderResult createBackgroundCheckOrderResult) {
            Utils.checkNotNull(createBackgroundCheckOrderResult, "createBackgroundCheckOrderResult");
            this.createBackgroundCheckOrderResult = Optional.ofNullable(createBackgroundCheckOrderResult);
            return this;
        }

        public Builder createBackgroundCheckOrderResult(Optional<? extends CreateBackgroundCheckOrderResult> createBackgroundCheckOrderResult) {
            Utils.checkNotNull(createBackgroundCheckOrderResult, "createBackgroundCheckOrderResult");
            this.createBackgroundCheckOrderResult = createBackgroundCheckOrderResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsOrderBackgroundCheckRequestResponse build() {
            return new AtsOrderBackgroundCheckRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.createBackgroundCheckOrderResult, this.headers);
        }
    }
}

