/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.SmsTemplatesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingListSmsTemplatesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends SmsTemplatesPaginated> smsTemplatesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingListSmsTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends SmsTemplatesPaginated> smsTemplatesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(smsTemplatesPaginated, "smsTemplatesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.smsTemplatesPaginated = smsTemplatesPaginated;
        this.headers = headers;
    }

    public MarketingListSmsTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<SmsTemplatesPaginated> smsTemplatesPaginated() {
        return this.smsTemplatesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MarketingListSmsTemplatesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingListSmsTemplatesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingListSmsTemplatesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingListSmsTemplatesResponse withSmsTemplatesPaginated(SmsTemplatesPaginated smsTemplatesPaginated) {
        Utils.checkNotNull(smsTemplatesPaginated, "smsTemplatesPaginated");
        this.smsTemplatesPaginated = Optional.ofNullable(smsTemplatesPaginated);
        return this;
    }

    public MarketingListSmsTemplatesResponse withSmsTemplatesPaginated(Optional<? extends SmsTemplatesPaginated> smsTemplatesPaginated) {
        Utils.checkNotNull(smsTemplatesPaginated, "smsTemplatesPaginated");
        this.smsTemplatesPaginated = smsTemplatesPaginated;
        return this;
    }

    public MarketingListSmsTemplatesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingListSmsTemplatesResponse other = (MarketingListSmsTemplatesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.smsTemplatesPaginated, other.smsTemplatesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.smsTemplatesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingListSmsTemplatesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "smsTemplatesPaginated", this.smsTemplatesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends SmsTemplatesPaginated> smsTemplatesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder smsTemplatesPaginated(SmsTemplatesPaginated smsTemplatesPaginated) {
            Utils.checkNotNull(smsTemplatesPaginated, "smsTemplatesPaginated");
            this.smsTemplatesPaginated = Optional.ofNullable(smsTemplatesPaginated);
            return this;
        }

        public Builder smsTemplatesPaginated(Optional<? extends SmsTemplatesPaginated> smsTemplatesPaginated) {
            Utils.checkNotNull(smsTemplatesPaginated, "smsTemplatesPaginated");
            this.smsTemplatesPaginated = smsTemplatesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MarketingListSmsTemplatesResponse build() {
            return new MarketingListSmsTemplatesResponse(this.contentType, this.statusCode, this.rawResponse, this.smsTemplatesPaginated, this.headers);
        }
    }
}

