/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.turtlequeue.Admin;
import com.turtlequeue.AuthenticationCallCredentials;
import com.turtlequeue.ClientImpl;
import com.turtlequeue.GrpcLoggingClientInterceptor;
import com.turtlequeue.MessageId;
import com.turtlequeue.Topic;
import com.turtlequeue.TopicImpl;
import com.turtlequeue.sdk.api.proto.Tq;
import com.turtlequeue.sdk.api.proto.Tqadmin;
import com.turtlequeue.sdk.api.proto.TurtleQueueAdminGrpc;
import com.turtlequeue.sdk.api.proto.TurtleQueueGrpc;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class AdminImpl
implements Admin {
    private static final Logger logger = Logger.getLogger(TurtleQueueGrpc.class.getName());
    TurtleQueueAdminGrpc.TurtleQueueAdminFutureStub stub = null;
    ClientImpl c = null;
    ExecutorService executor = null;

    public AdminImpl(ClientImpl c) {
        this.c = c;
        this.executor = Executors.newFixedThreadPool(2);
        this.stub = (TurtleQueueAdminGrpc.TurtleQueueAdminFutureStub)TurtleQueueAdminGrpc.newFutureStub((Channel)ClientInterceptors.intercept((Channel)this.c.tqClient.getChannel(), (List)new ArrayList<ClientInterceptor>(){
            {
                this.add(new GrpcLoggingClientInterceptor("[Admin] "));
            }
        })).withCallCredentials((CallCredentials)new AuthenticationCallCredentials(this.c.getUserToken(), this.c.getApiKey(), this.c.getAuthMethod(), this.c.getDataFormat(), this.c.getSdkVersion()));
    }

    public static void initialize() {
        ClientImpl.registerAdmin(AdminImpl.class);
    }

    protected <T> CompletableFuture<T> toCompletableFuture(ListenableFuture<T> f) {
        final CompletableFuture res = new CompletableFuture();
        Futures.addCallback(f, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T val) {
                res.complete(val);
            }

            public void onFailure(Throwable t) {
                res.completeExceptionally(t);
            }
        }, (Executor)this.executor);
        return res;
    }

    public CompletableFuture<Void> deleteTopic(Topic t, boolean force, boolean deleteSchema) {
        ListenableFuture response = this.stub.topicDelete(Tqadmin.TopicDeleteRequest.newBuilder().setTopic(TopicImpl.toTqTopic((Topic)t)).setForce(force).setDeleteSchema(deleteSchema).build());
        return this.toCompletableFuture(response).thenApply(topicResponse -> null);
    }

    public CompletableFuture<Void> deleteTopic(Topic t, boolean force) {
        return this.deleteTopic(t, force, false);
    }

    public CompletableFuture<Void> deleteTopic(Topic t) {
        return this.deleteTopic(t, false, false);
    }

    public CompletableFuture<MessageId> terminateTopic(Topic t) {
        ListenableFuture response = this.stub.topicTerminate(Tqadmin.TopicTerminateRequest.newBuilder().setTopic(TopicImpl.toTqTopic((Topic)t)).build());
        return this.toCompletableFuture(response).thenApply(termResponse -> MessageId.fromMessageIdData((Tq.MessageIdData)termResponse.getMessageId()));
    }
}

