/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.chartjs.model.charts;

import software.xdev.chartjs.model.charts.AbstractChart;
import software.xdev.chartjs.model.data.LineData;
import software.xdev.chartjs.model.dataset.LineDataset;
import software.xdev.chartjs.model.options.LineOptions;

public class LineChart
extends AbstractChart<LineChart, LineOptions, LineData> {
    public LineChart() {
    }

    public LineChart(LineData data) {
        super(data);
    }

    public LineChart(LineData data, LineOptions options) {
        super(data, options);
    }

    public static LineData data() {
        return new LineData();
    }

    public static LineOptions options() {
        return new LineOptions();
    }

    @Override
    public String getType() {
        return "line";
    }

    @Override
    public boolean isDrawable() {
        boolean sufficientData = false;
        for (LineDataset dataset : ((LineData)this.getData()).getDatasets()) {
            if (dataset.getXAxisID() != null && !this.hasScaleWithId(dataset.getXAxisID())) {
                return false;
            }
            if (dataset.getYAxisID() != null && !this.hasScaleWithId(dataset.getYAxisID())) {
                return false;
            }
            if (dataset.getData().isEmpty()) continue;
            sufficientData = true;
        }
        return sufficientData;
    }

    private boolean hasScaleWithId(String id) {
        if (this.getOptions() != null && ((LineOptions)this.getOptions()).getScales() != null && ((LineOptions)this.getOptions()).getScales().getScalesList() != null) {
            return ((LineOptions)this.getOptions()).getScales().getScalesList().get(id) != null;
        }
        return false;
    }
}

