/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.filesearch;

import io.github.codejanovic.java.filesearch.filesystem.Directory;
import io.github.codejanovic.java.filesearch.filesystem.FileEntry;
import io.github.codejanovic.java.filesearch.iterator.file.DirectoryIterator;
import io.github.codejanovic.java.filesearch.iterator.file.RecursiveDirectoryIterator;
import io.github.codejanovic.java.filesearch.iterator.path.RecursiveSilentDirectoryIterator;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface FileSearch<T> {
    default public Stream<T> stream() {
        int characteristics = 21;
        Spliterator<T> splitIterator = Spliterators.spliteratorUnknownSize(this.iterator(), 21);
        return StreamSupport.stream(splitIterator, false);
    }

    public Iterator<T> iterator();

    public static final class ByFileRecursive
    implements FileSearch<File> {
        private final File directory;

        public ByFileRecursive(File directory) {
            this.directory = directory;
        }

        public ByFileRecursive(Path directory) {
            this.directory = directory.toFile();
        }

        @Override
        public Iterator iterator() {
            return new RecursiveDirectoryIterator(this.directory);
        }
    }

    public static final class ByFile
    implements FileSearch<File> {
        private final File directory;

        public ByFile(File directory) {
            this.directory = directory;
        }

        public ByFile(Path directory) {
            this.directory = directory.toFile();
        }

        @Override
        public Iterator iterator() {
            return new DirectoryIterator(this.directory);
        }
    }

    public static final class ByPathRecursive
    implements FileSearch<Path> {
        private final Path directory;

        public ByPathRecursive(Path directory) {
            this.directory = directory;
        }

        public ByPathRecursive(File directory) {
            this.directory = directory.toPath();
        }

        @Override
        public Iterator<Path> iterator() {
            return new RecursiveSilentDirectoryIterator(new Directory.Smart(new FileEntry.Smart(this.directory)));
        }
    }

    public static final class ByPath
    implements FileSearch<Path> {
        private final Path directory;

        public ByPath(Path directory) {
            this.directory = directory;
        }

        public ByPath(File directory) {
            this.directory = directory.toPath();
        }

        @Override
        public Iterator<Path> iterator() {
            return new io.github.codejanovic.java.filesearch.iterator.path.DirectoryIterator(new Directory.Smart(new FileEntry.Smart(this.directory)));
        }
    }
}

