/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.filesearch.filesystem.attributes;

import io.github.codejanovic.java.filesearch.filesystem.Attributes;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public final class NoFollowLinks
implements Attributes {
    private final Path path;

    public NoFollowLinks(Path path) {
        this.path = path;
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public boolean followLinks() {
        return false;
    }

    @Override
    public BasicFileAttributes load() throws IOException {
        return Files.readAttributes(this.path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoFollowLinks that = (NoFollowLinks)o;
        return this.path != null ? this.path.equals(that.path) : that.path == null;
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }
}

