/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.filesearch.iterator;

import io.github.codejanovic.java.filesearch.iterator.CloseableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Stack;

public interface RepeatableIterator<T>
extends Iterator<T> {
    public boolean hasCurrent();

    public T current();

    public static final class Closeable<T>
    implements java.io.Closeable,
    RepeatableIterator<T> {
        private final RepeatableIterator<T> repeatableIterator;
        private final CloseableIterator<T> closeableIterator;

        public Closeable(CloseableIterator<T> closeableIterator, RepeatableIterator<T> repeatableIterator) {
            this.closeableIterator = closeableIterator;
            this.repeatableIterator = repeatableIterator;
        }

        public Closeable(CloseableIterator<T> closeableIterator) {
            this(closeableIterator, new Smart<T>(closeableIterator));
        }

        @Override
        public boolean hasCurrent() {
            return this.repeatableIterator.hasCurrent();
        }

        @Override
        public T current() {
            return this.repeatableIterator.current();
        }

        @Override
        public boolean hasNext() {
            return this.repeatableIterator.hasNext();
        }

        @Override
        public T next() {
            return (T)this.repeatableIterator.next();
        }

        @Override
        public void close() throws IOException {
            this.closeableIterator.close();
        }
    }

    public static final class Smart<T>
    implements RepeatableIterator<T> {
        private final Stack<T> stack = new Stack();
        private final Iterator<T> iterator;

        public Smart(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasCurrent() {
            return !this.stack.isEmpty();
        }

        @Override
        public T current() {
            return this.stack.peek();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.stack.isEmpty()) {
                this.stack.pop();
            }
            return this.stack.push(this.iterator.next());
        }
    }
}

