/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.filesearch.iterator.file;

import io.github.codejanovic.java.filesearch.iterator.RepeatableIterator;
import io.github.codejanovic.java.filesearch.iterator.file.DirectoryIterator;
import io.github.codejanovic.java.filesearch.iterator.file.FileIterator;
import java.io.File;
import java.util.Iterator;
import java.util.Stack;

public class RecursiveDirectoryIterator
implements Iterator<File> {
    private final Stack<RepeatableIterator<File>> iteratorStack = new Stack();
    private RepeatableIterator<File> iterator;

    public RecursiveDirectoryIterator(File start) {
        this.iterator = start.isDirectory() ? new RepeatableIterator.Smart<File>(new DirectoryIterator(start)) : new RepeatableIterator.Smart<File>(new FileIterator(start));
    }

    @Override
    public boolean hasNext() {
        if (this.givenCurrentFile()) {
            this.whenCurrentFileIsADirectoryDoOpenIt();
        }
        if (this.givenNoNextEntry() && this.whenThereAreQueuedFiles()) {
            this.thenDequeueThoseFilesUntilThereIsANextEntryOrNoFilesLeft();
        }
        return this.iterator.hasNext();
    }

    @Override
    public File next() {
        return (File)this.iterator.next();
    }

    private boolean givenCurrentFile() {
        return this.iterator.hasCurrent();
    }

    private void thenDequeueThoseFilesUntilThereIsANextEntryOrNoFilesLeft() {
        while (this.givenNoNextEntry()) {
            if (this.whenThereAreQueuedFiles()) {
                this.iterator = this.iteratorStack.pop();
                continue;
            }
            return;
        }
    }

    private boolean whenThereAreQueuedFiles() {
        return !this.iteratorStack.isEmpty();
    }

    private boolean givenNoNextEntry() {
        return !this.iterator.hasNext();
    }

    private void whenCurrentFileIsADirectoryDoOpenIt() {
        File current = this.iterator.current();
        if (!current.isDirectory()) {
            return;
        }
        this.openDirectoryIfItIsNotEmpty(current);
    }

    private void openDirectoryIfItIsNotEmpty(File current) {
        RepeatableIterator.Smart<File> currentDirectoryIterator = new RepeatableIterator.Smart<File>(new DirectoryIterator(current));
        if (!currentDirectoryIterator.hasNext()) {
            return;
        }
        this.iteratorStack.push(this.iterator);
        this.iterator = currentDirectoryIterator;
    }
}

