/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.filesearch.iterator.path;

import io.github.codejanovic.java.filesearch.filesystem.Directory;
import io.github.codejanovic.java.filesearch.iterator.CloseableIterator;
import io.github.codejanovic.java.filesearch.iterator.empty.EmptyIterator;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Stack;

public class DirectoryIterator
implements CloseableIterator<Path> {
    private final Stack<DirectoryStream<Path>> stream = new Stack();
    private final Stack<Iterator<Path>> iterator = new Stack();
    private final Directory directory;

    public DirectoryIterator(Directory directory) {
        this.directory = directory;
    }

    @Override
    public void close() throws IOException {
        if (this.stream.empty()) {
            return;
        }
        this.stream.pop().close();
    }

    private void openDirectoryIfNecessary() {
        if (!this.iterator.empty()) {
            return;
        }
        try {
            this.iterator.push(this.stream.push(this.directory.open()).iterator());
        }
        catch (IOException e) {
            this.iterator.push(new EmptyIterator());
        }
    }

    @Override
    public boolean hasNext() {
        this.openDirectoryIfNecessary();
        return this.iterator.peek().hasNext();
    }

    @Override
    public Path next() {
        this.openDirectoryIfNecessary();
        return this.iterator.peek().next();
    }
}

