/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.graphQLProcessors;

import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.retrievers.GraphQLInputObjectRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectHandler;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.Map;

public class GraphQLInputProcessor {
    private static final String DEFAULT_INPUT_PREFIX = "Input";
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;
    private GraphQLObjectHandler graphQLObjectHandler;
    private GraphQLInputObjectRetriever graphQLInputObjectRetriever;

    public GraphQLInputProcessor(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever, GraphQLObjectHandler graphQLObjectHandler, GraphQLInputObjectRetriever graphQLInputObjectRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
        this.graphQLObjectHandler = graphQLObjectHandler;
        this.graphQLInputObjectRetriever = graphQLInputObjectRetriever;
    }

    public GraphQLInputProcessor() {
        this(new GraphQLObjectInfoRetriever(), new GraphQLObjectHandler(), new GraphQLInputObjectRetriever());
    }

    public GraphQLInputObjectType getInputObject(Class<?> object, ProcessingElementsContainer container) {
        String typeName = DEFAULT_INPUT_PREFIX + this.graphQLObjectInfoRetriever.getTypeName(object);
        Map<String, GraphQLType> typeRegistry = container.getTypeRegistry();
        if (typeRegistry.containsKey(typeName)) {
            return (GraphQLInputObjectType)container.getTypeRegistry().get(typeName);
        }
        GraphQLObjectType graphQLType = this.graphQLObjectHandler.getObject(object, container);
        GraphQLInputObjectType inputObject = (GraphQLInputObjectType)this.graphQLInputObjectRetriever.getInputObject((GraphQLType)graphQLType, DEFAULT_INPUT_PREFIX, typeRegistry);
        typeRegistry.put(inputObject.getName(), (GraphQLType)inputObject);
        return inputObject;
    }
}

