/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.util;

import graphql.annotations.connection.ConnectionValidator;
import graphql.annotations.connection.GraphQLConnection;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import java.lang.reflect.AccessibleObject;
import java.util.Arrays;
import java.util.List;

public class ConnectionUtil {
    private static final List<Class> TYPES_FOR_CONNECTION = Arrays.asList(GraphQLObjectType.class, GraphQLInterfaceType.class, GraphQLUnionType.class, GraphQLTypeReference.class);

    public static boolean isConnection(AccessibleObject obj, GraphQLOutputType type) {
        boolean isValidGraphQLTypeForConnection;
        if (type instanceof GraphQLNonNull) {
            type = (GraphQLOutputType)((GraphQLNonNull)type).getWrappedType();
        }
        GraphQLOutputType actualType = type;
        boolean bl = isValidGraphQLTypeForConnection = obj.isAnnotationPresent(GraphQLConnection.class) && actualType instanceof GraphQLList && TYPES_FOR_CONNECTION.stream().anyMatch(aClass -> aClass.isInstance(((GraphQLList)actualType).getWrappedType()));
        if (isValidGraphQLTypeForConnection) {
            ConnectionValidator validator = ReflectionKit.newInstance(obj.getAnnotation(GraphQLConnection.class).validator());
            validator.validate(obj);
            return true;
        }
        return false;
    }
}

