package io.github.kaststream.api.v2.facade;

import java.util.Collection;

public interface KastResultFuture {
  /**
   * Completes the result future with a collection of result objects.
   *
   * <p>Note that it should be called for exactly one time in the user code. Calling this function
   * for multiple times will cause data lose.
   *
   * <p>Put all results in a {@link Collection} and then emit output.
   *
   * @param kastRows A list of results.
   */
  void complete(Collection<KastRow> kastRows);

  /**
   * Completes the result future exceptionally with an exception.
   *
   * @param throwable A Throwable object.
   */
  void completeExceptionally(Throwable throwable);
}
