/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import com.madgag.gif.fmsware.GifDecoder;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.sf.image4j.codec.ico.ICODecoder;

public class ChatImageHandler {
    public static void AddChatImage(ChatImageFrame frame, String url) {
        ChatImageCode.CACHE_MAP.put(url, frame);
    }

    public static void AddChatImage(BufferedImage image, String url) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            ChatImageHandler.AddChatImage(new ByteArrayInputStream(os.toByteArray()), url);
        }
        catch (IOException e) {
            ChatImageCode.CACHE_MAP.put(url, new ChatImageFrame(ChatImageFrame.FrameError.FILE_LOAD_ERROR));
        }
    }

    public static void AddChatImage(InputStream image, String url) {
        try {
            ChatImageHandler.AddChatImage(new ChatImageFrame(image), url);
        }
        catch (IOException e) {
            ChatImageCode.CACHE_MAP.put(url, new ChatImageFrame(ChatImageFrame.FrameError.FILE_LOAD_ERROR));
        }
    }

    public static void AddChatImageError(String url, ChatImageFrame.FrameError error) {
        ChatImageCode.CACHE_MAP.put(url, new ChatImageFrame(error));
    }

    public static void loadGif(InputStream is, String url) {
        CompletableFuture.supplyAsync(() -> {
            try {
                GifDecoder gd = new GifDecoder();
                int status = gd.read(is);
                if (status != 0) {
                    ChatImageHandler.AddChatImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
                    return null;
                }
                ChatImageFrame frame = new ChatImageFrame(gd.getFrame(0));
                for (int i = 1; i < gd.getFrameCount(); ++i) {
                    frame.append(new ChatImageFrame(gd.getFrame(i)));
                }
                ChatImageCode.CACHE_MAP.put(url, frame);
            }
            catch (IOException ignored) {
                ChatImageHandler.AddChatImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
            }
            return null;
        });
    }

    public static void loadGif(byte[] is, String url) {
        ChatImageHandler.loadGif(new ByteArrayInputStream(is), url);
    }

    public static void loadFile(byte[] input, String url) throws IOException {
        ChatImageCode.ChatImageType t = ChatImageHandler.getPicType(input);
        if (t == ChatImageCode.ChatImageType.GIF) {
            ChatImageHandler.loadGif(input, url);
        } else if (t == ChatImageCode.ChatImageType.ICO) {
            List<BufferedImage> images = ICODecoder.read(new ByteArrayInputStream(input));
            ChatImageHandler.AddChatImage(images.get(0), url);
        } else if (t == ChatImageCode.ChatImageType.PNG) {
            ChatImageHandler.AddChatImage(ImageIO.read(new ByteArrayInputStream(input)), url);
        } else if (t == ChatImageCode.ChatImageType.WEBP) {
            // empty if block
        }
    }

    public static void loadFile(InputStream input, String url) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = input.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        byte[] byteArray = buffer.toByteArray();
        ChatImageHandler.loadFile(byteArray, url);
    }

    public static void loadFile(String url) throws IOException {
        ChatImageHandler.loadFile(Files.newInputStream(Paths.get(url, new String[0]), new OpenOption[0]), url);
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static ChatImageCode.ChatImageType getPicType(byte[] is) {
        byte[] b = new byte[4];
        System.arraycopy(is, 0, b, 0, b.length);
        String type_ = ChatImageHandler.bytesToHex(b).toUpperCase();
        if (type_.startsWith("47494638")) {
            return ChatImageCode.ChatImageType.GIF;
        }
        if (type_.startsWith("00000100")) {
            return ChatImageCode.ChatImageType.ICO;
        }
        if (type_.startsWith("52494646")) {
            return ChatImageCode.ChatImageType.WEBP;
        }
        return ChatImageCode.ChatImageType.PNG;
    }
}

