/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon.nats.message;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mainstringargs.polygon.domain.StockQuote;
import io.github.mainstringargs.polygon.enums.ChannelType;
import io.github.mainstringargs.polygon.nats.message.ChannelMessage;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class QuotesMessage
implements ChannelMessage {
    private String ticker;
    private ChannelType channelType;
    private StockQuote stockQuote;
    private LocalDateTime timestamp;
    private static Gson gson;

    public QuotesMessage(ChannelType cType, String ticker, JsonObject jsonObject) {
        this.ticker = ticker;
        this.channelType = cType;
        JsonObject jsonQuote = jsonObject.getAsJsonObject();
        this.stockQuote = (StockQuote)gson.fromJson((JsonElement)jsonQuote, StockQuote.class);
        this.timestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.stockQuote.getT()), ZoneId.systemDefault());
    }

    @Override
    public String getTicker() {
        return this.ticker;
    }

    @Override
    public ChannelType getChannelType() {
        return this.channelType;
    }

    public StockQuote getStockQuote() {
        return this.stockQuote;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channelType == null ? 0 : this.channelType.hashCode());
        result = 31 * result + (this.stockQuote == null ? 0 : this.stockQuote.hashCode());
        result = 31 * result + (this.ticker == null ? 0 : this.ticker.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuotesMessage other = (QuotesMessage)obj;
        if (this.channelType != other.channelType) {
            return false;
        }
        if (this.stockQuote == null ? other.stockQuote != null : !this.stockQuote.equals(other.stockQuote)) {
            return false;
        }
        if (this.ticker == null ? other.ticker != null : !this.ticker.equals(other.ticker)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }

    public String toString() {
        return "QuotesMessage [ticker=" + this.ticker + ", channelType=" + (Object)((Object)this.channelType) + ", stockQuote=" + this.stockQuote + ", timestamp=" + this.timestamp + "]";
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        gson = gsonBuilder.create();
    }
}

