/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbridge.util;

import io.github.kbridge.props.EtlProperties;
import io.github.kbridge.transform.KafkaPayloadTransformer;
import io.github.kbridge.transform.MqPayloadTransformer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransformerUtil {
    @Autowired
    private EtlProperties etlProperties;

    public List<KafkaPayloadTransformer> findKafkaTransformer(String topic) {
        List<KafkaPayloadTransformer> kafkaPayloadTransformer = this.etlProperties.getKafkaMap().get(topic);
        if (Objects.isNull(kafkaPayloadTransformer)) {
            throw new RuntimeException(String.format("transformer not found for kafka topic : %s", kafkaPayloadTransformer));
        }
        return kafkaPayloadTransformer;
    }

    public List<MqPayloadTransformer> findMqTransformer(Message message) {
        List<MqPayloadTransformer> mqPayloadTransformer = null;
        String mqTopicName = null;
        try {
            mqTopicName = this.extractTopic(message);
            mqPayloadTransformer = this.findMqTransformer(mqTopicName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mqPayloadTransformer;
    }

    public List<MqPayloadTransformer> findMqTransformer(String mqTopicName) {
        List<MqPayloadTransformer> mqPayloadTransformer = null;
        Map<String, List<MqPayloadTransformer>> mqMap = this.etlProperties.getMqMap();
        mqPayloadTransformer = mqMap.get(mqTopicName);
        if (Objects.isNull(mqPayloadTransformer)) {
            throw new RuntimeException(String.format("transformer not found for mq topic : %s", mqTopicName));
        }
        return mqPayloadTransformer;
    }

    public String extractTopic(Message message) {
        String mqTopicName = null;
        try {
            mqTopicName = message.getJMSDestination().toString();
            mqTopicName = StringUtils.substringAfter((String)mqTopicName, (String)"///");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return mqTopicName;
    }
}

