/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Utilities;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.FileHandler;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import ArmyC2.C2SD.Utilities.UnitFontLookupInfo;
import ArmyC2.C2SD.Utilities.XMLUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;

public class UnitFontLookupC {
    private static UnitFontLookupC _instance;
    private boolean _ready = false;
    HashMap<String, UnitFontLookupInfo> hashMap = new HashMap();
    private static final int FillIndexUZ = 800;
    private static final int FillIndexUP = 849;
    private static final int FillIndexUA = 825;
    private static final int FillIndexUG = 800;
    private static final int FillIndexUGE = 800;
    private static final int FillIndexUS = 800;
    private static final int FillIndexUU = 837;
    private static final int FillIndexUF = 800;
    private static final int FillIndexFZ = 812;
    private static final int FillIndexFP = 843;
    private static final int FillIndexFA = 819;
    private static final int FillIndexFG = 803;
    private static final int FillIndexFGE = 812;
    private static final int FillIndexFS = 812;
    private static final int FillIndexFU = 831;
    private static final int FillIndexFF = 803;
    private static final int FillIndexNZ = 809;
    private static final int FillIndexNP = 846;
    private static final int FillIndexNA = 822;
    private static final int FillIndexNG = 809;
    private static final int FillIndexNGE = 809;
    private static final int FillIndexNS = 809;
    private static final int FillIndexNU = 834;
    private static final int FillIndexNF = 809;
    private static final int FillIndexHZ = 806;
    private static final int FillIndexHP = 840;
    private static final int FillIndexHA = 816;
    private static final int FillIndexHG = 806;
    private static final int FillIndexHGE = 806;
    private static final int FillIndexHS = 806;
    private static final int FillIndexHU = 828;
    private static final int FillIndexHF = 806;

    public boolean getReady() {
        return this._ready;
    }

    private UnitFontLookupC() {
        this.init();
    }

    public static synchronized UnitFontLookupC getInstance() {
        if (_instance == null) {
            _instance = new UnitFontLookupC();
        }
        return _instance;
    }

    private void init() {
        this.xmlLoaded();
    }

    private void xmlLoaded() {
        String xmlPath = null;
        xmlPath = RendererSettings.getInstance().getSymbologyStandard() == 1 ? "XML/UnitFontMappingsC.xml" : "XML/UnitFontMappingsB.xml";
        InputStream xmlStream = this.getClass().getClassLoader().getResourceAsStream(xmlPath);
        String lookupXml = FileHandler.InputStreamToString(xmlStream);
        this.populateLookup(lookupXml);
    }

    private void populateLookup(String xml) {
        ArrayList<String> al = XMLUtil.getItemList(xml, "<SYMBOL>", "</SYMBOL>");
        for (int i = 0; i < al.size(); ++i) {
            String data = al.get(i);
            String ID = XMLUtil.parseTagValue(data, "<SYMBOLID>", "</SYMBOLID>");
            String description = XMLUtil.parseTagValue(data, "<DESCRIPTION>", "</DESCRIPTION>");
            String m1u = XMLUtil.parseTagValue(data, "<MAPPING1U>", "</MAPPING1U>");
            String m1f = XMLUtil.parseTagValue(data, "<MAPPING1F>", "</MAPPING1F>");
            String m1n = XMLUtil.parseTagValue(data, "<MAPPING1N>", "</MAPPING1N>");
            String m1h = XMLUtil.parseTagValue(data, "<MAPPING1H>", "</MAPPING1H>");
            String m2 = XMLUtil.parseTagValue(data, "<MAPPING2>", "</MAPPING2>");
            String c1 = XMLUtil.parseTagValue(data, "<MAPPING1COLOR>", "</MAPPING1COLOR>");
            String c2 = XMLUtil.parseTagValue(data, "<MAPPING2COLOR>", "</MAPPING2COLOR>");
            UnitFontLookupInfo uflTemp = null;
            uflTemp = new UnitFontLookupInfo(ID, description, m1u, m1f, m1n, m1h, c1, m2, c2);
            if (uflTemp == null) continue;
            this.hashMap.put(ID, uflTemp);
        }
    }

    private String resolveAffiliation(String symbolID) {
        String code = symbolID.substring(0);
        String affiliation = symbolID.substring(1, 2);
        if (affiliation.equals("F") || affiliation.equals("H") || affiliation.equals("U") || affiliation.equals("N")) {
            return code;
        }
        code = affiliation.equals("S") ? code.substring(0, 1) + "H" + code.substring(2, 15) : (affiliation.equals("L") ? code.substring(0, 1) + "N" + code.substring(2, 15) : (affiliation.equals("A") || affiliation.equals("D") || affiliation.equals("M") || affiliation.equals("K") || affiliation.equals("J") ? code.substring(0, 1) + "F" + code.substring(2, 15) : (affiliation.equals("P") || affiliation.equals("G") || affiliation.equals("O") || affiliation.equals("W") ? code.substring(0, 1) + "U" + code.substring(2, 15) : code.substring(0, 1) + "U" + code.substring(2, 15))));
        return code;
    }

    public static UnitFontLookupInfo adjustSubSurfaceIfNot2525C(UnitFontLookupInfo original) {
        UnitFontLookupInfo result = null;
        return result;
    }

    public static int getFillCode(String SymbolID2) {
        int returnVal = -1;
        char scheme = '\u0000';
        char battleDimension = '\u0000';
        char status = '\u0000';
        char affiliation = '\u0000';
        char grdtrkSubset = '\u0000';
        try {
            if (SymbolID2 != null && SymbolID2.length() == 15) {
                scheme = SymbolID2.charAt(0);
                affiliation = SymbolID2.charAt(1);
                battleDimension = SymbolID2.charAt(2);
                status = SymbolID2.charAt(3);
                grdtrkSubset = SymbolID2.charAt(4);
                if (scheme == 'S') {
                    if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K') {
                        if (battleDimension == 'Z') {
                            returnVal = 812;
                        } else if (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S') {
                            returnVal = battleDimension == 'F' || battleDimension == 'G' && (grdtrkSubset == 'U' || grdtrkSubset == 'I' || grdtrkSubset == '0' || grdtrkSubset == '-') ? 803 : (battleDimension == 'S' || battleDimension == 'G' && grdtrkSubset == 'E' ? 812 : 803);
                        } else if (battleDimension == 'A') {
                            returnVal = 819;
                        } else if (battleDimension == 'U') {
                            returnVal = UnitFontLookupC.getSubSurfaceFill(SymbolID2);
                        } else if (battleDimension == 'P') {
                            returnVal = 843;
                        }
                    } else if (affiliation == 'H' || affiliation == 'S') {
                        returnVal = battleDimension == 'Z' ? 806 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? 806 : (battleDimension == 'A' ? 816 : (battleDimension == 'U' ? UnitFontLookupC.getSubSurfaceFill(SymbolID2) : (battleDimension == 'P' ? 840 : 806))));
                    } else if (affiliation == 'N' || affiliation == 'L') {
                        returnVal = battleDimension == 'Z' ? 809 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? 809 : (battleDimension == 'A' ? 822 : (battleDimension == 'U' ? UnitFontLookupC.getSubSurfaceFill(SymbolID2) : (battleDimension == 'P' ? 846 : 809))));
                    } else if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                        returnVal = battleDimension == 'Z' || battleDimension == 'G' || battleDimension == 'S' || battleDimension == 'F' ? 800 : (battleDimension == 'A' ? 825 : (battleDimension == 'U' ? UnitFontLookupC.getSubSurfaceFill(SymbolID2) : (battleDimension == 'P' ? 849 : 800)));
                    }
                } else if (scheme == 'E') {
                    returnVal = battleDimension != 'N' ? (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' ? (SymbolUtilities.isEMSEquipment(SymbolID2) ? 812 : 803) : (affiliation == 'H' || affiliation == 'S' ? 806 : (affiliation == 'N' || affiliation == 'L' ? 809 : 800))) : -1;
                } else if (scheme == 'I') {
                    if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K') {
                        returnVal = battleDimension == 'Z' ? 812 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? (scheme == 'I' ? 812 : 803) : (battleDimension == 'A' ? 819 : (battleDimension == 'U' ? 831 : (battleDimension == 'P' ? 843 : (scheme == 'I' ? 812 : 803)))));
                    }
                    if (affiliation == 'H' || affiliation == 'S') {
                        returnVal = battleDimension == 'Z' ? 806 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? 806 : (battleDimension == 'A' ? 816 : (battleDimension == 'U' ? 828 : (battleDimension == 'P' ? 840 : 806))));
                    }
                    if (affiliation == 'N' || affiliation == 'L') {
                        returnVal = battleDimension == 'Z' ? 809 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? 809 : (battleDimension == 'A' ? 822 : (battleDimension == 'U' ? 834 : (battleDimension == 'P' ? 846 : 809))));
                    } else if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                        returnVal = battleDimension == 'Z' || battleDimension == 'G' || battleDimension == 'S' || battleDimension == 'F' ? 800 : (battleDimension == 'A' ? 825 : (battleDimension == 'U' ? 837 : (battleDimension == 'P' ? 849 : 800)));
                    }
                } else {
                    returnVal = affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' ? 803 : (affiliation == 'H' || affiliation == 'S' ? 806 : (affiliation == 'N' || affiliation == 'L' ? 809 : 800));
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookup", "getFillCode", exc, Level.SEVERE);
        }
        return returnVal;
    }

    public static int getFrameCode(String SymbolID2, int FillCode) {
        int returnVal = 0;
        char status = SymbolID2.charAt(3);
        returnVal = status == 'A' ? FillCode + 2 : FillCode + 1;
        if (SymbolUtilities.isSubSurface(SymbolID2)) {
            returnVal = UnitFontLookupC.getSubSurfaceFrame(SymbolID2, FillCode);
        }
        return returnVal;
    }

    private static int getSubSurfaceFill(String SymbolID2) {
        char affiliation = '\u0000';
        char status = '\u0000';
        int returnVal = 0;
        returnVal = 831;
        try {
            affiliation = SymbolID2.charAt(1);
            status = SymbolID2.charAt(3);
            if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K') {
                returnVal = 831;
            } else if (affiliation == 'H' || affiliation == 'S') {
                returnVal = 828;
            } else if (affiliation == 'N' || affiliation == 'L') {
                returnVal = 834;
            } else if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                returnVal = 837;
            }
            if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*X-----*****")) {
                returnVal = status == 'A' ? (returnVal += 2) : ++returnVal;
            }
            if (RendererSettings.getInstance().getSymbologyStandard() == 1) {
                if (SymbolID2.indexOf("WM") == 4 || SymbolID2.indexOf("WDM") == 4 || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*E-----*****") || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*V-----*****") || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*X-----*****")) {
                    ++returnVal;
                    if (status == 'A') {
                        ++returnVal;
                    }
                } else if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*ND----*****")) {
                    returnVal = 2121;
                }
            } else if (SymbolID2.indexOf("WM") == 4) {
                if (SymbolID2.indexOf("----", 6) == 6 || SymbolID2.indexOf("D---", 6) == 6) {
                    returnVal = 2059;
                } else if (SymbolID2.indexOf("G---", 6) == 6) {
                    returnVal = 2062;
                } else if (SymbolID2.indexOf("GD--", 6) == 6) {
                    returnVal = 2064;
                } else if (SymbolID2.indexOf("M---", 6) == 6) {
                    returnVal = 2073;
                } else if (SymbolID2.indexOf("MD--", 6) == 6) {
                    returnVal = 2075;
                } else if (SymbolID2.indexOf("F---", 6) == 6) {
                    returnVal = 2084;
                } else if (SymbolID2.indexOf("FD--", 6) == 6) {
                    returnVal = 2086;
                } else if (SymbolID2.indexOf("O---", 6) == 6 || SymbolID2.indexOf("OD--", 6) == 6) {
                    returnVal = 2094;
                }
            } else if (SymbolID2.indexOf("WDM") == 4) {
                returnVal = 2115;
            } else if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*ND----*****")) {
                returnVal = 2121;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookupC", "getSubSurfaceFill", exc);
            return 831;
        }
        return returnVal;
    }

    private static int getSubSurfaceFrame(String SymbolID2, int fillCode) {
        int returnVal;
        block11: {
            returnVal = 0;
            returnVal = 831;
            try {
                if (RendererSettings.getInstance().getSymbologyStandard() == 1) {
                    if (SymbolID2.indexOf("WM") == 4 || SymbolID2.indexOf("WDM") == 4 || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*E-----*****") || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*V-----*****") || SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*X-----*****")) {
                        returnVal = -1;
                        break block11;
                    }
                    if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*ND----*****")) {
                        returnVal = -1;
                        break block11;
                    }
                    if (SymbolID2.charAt(3) == 'A' || SymbolID2.charAt(3) == 'a') {
                        return fillCode + 2;
                    }
                    return fillCode + 1;
                }
                if (SymbolID2.indexOf("WM") == 4) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolID2.indexOf("WDM") == 4) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*ND----*****")) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolUtilities.getBasicSymbolIDStrict(SymbolID2).equalsIgnoreCase("S*U*X-----*****")) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolID2.charAt(3) == 'A' || SymbolID2.charAt(3) == 'a') {
                    return fillCode + 2;
                }
                return fillCode + 1;
            }
            catch (Exception exc) {
                ErrorLogger.LogException("UnitFontLookupC", "getSubSurfaceFrame", exc);
                return fillCode;
            }
        }
        return returnVal;
    }

    public UnitFontLookupInfo getLookupInfo(String SymbolID2) {
        try {
            String code = SymbolUtilities.getBasicSymbolIDStrict(SymbolID2);
            UnitFontLookupInfo data = this.hashMap.get(code);
            return data;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookupC", "getLookupInfo()", exc, Level.WARNING);
            return null;
        }
    }

    public static double getUnitRatioHeight(int characterIndex) {
        if (characterIndex == 840 || characterIndex == 816 || characterIndex == 828 || characterIndex == 829 || characterIndex == 830 || characterIndex == 849 || characterIndex == 825 || characterIndex == 837 || characterIndex == 838 || characterIndex == 839) {
            return 1.3;
        }
        if (characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800) {
            return 1.44;
        }
        if (characterIndex == 812 || characterIndex == 843 || characterIndex == 819 || characterIndex == 831 || characterIndex == 832 || characterIndex == 833 || characterIndex == 812 || characterIndex == 812 || characterIndex == 846 || characterIndex == 822 || characterIndex == 834 || characterIndex == 835 || characterIndex == 836) {
            return 1.2;
        }
        if (characterIndex == 809 || characterIndex == 809 || characterIndex == 809 || characterIndex == 809 || characterIndex == 809) {
            return 1.1;
        }
        if (characterIndex == 803 || characterIndex == 812) {
            return 1.0;
        }
        return 1.2;
    }

    public static double getUnitRatioWidth(int characterIndex) {
        if (characterIndex == 849 || characterIndex == 825 || characterIndex == 837 || characterIndex == 838 || characterIndex == 839 || characterIndex == 803 || characterIndex == 803) {
            return 1.5;
        }
        if (characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800) {
            return 1.44;
        }
        if (characterIndex == 812 || characterIndex == 812 || characterIndex == 812) {
            return 1.2;
        }
        return 1.1;
    }
}

