/*
 * Decompiled with CFR 0.152.
 */
package feign.example.github;

import feign.Feign;
import feign.Logger;
import feign.Param;
import feign.RequestLine;
import feign.Response;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;

public class GitHubExample {
    public static void main(String ... args) {
        GitHub github = GitHub.connect();
        System.out.println("Let's fetch and print a list of the contributors to this org.");
        List<String> contributors = github.contributors("openfeign");
        for (String contributor : contributors) {
            System.out.println(contributor);
        }
        System.out.println("Now, let's cause an error.");
        try {
            github.contributors("openfeign", "some-unknown-project");
        }
        catch (GitHubClientError e) {
            System.out.println(e.getMessage());
        }
    }

    static class GitHubErrorDecoder
    implements ErrorDecoder {
        final Decoder decoder;
        final ErrorDecoder defaultDecoder = new ErrorDecoder.Default();

        GitHubErrorDecoder(Decoder decoder) {
            this.decoder = decoder;
        }

        @Override
        public Exception decode(String methodKey, Response response) {
            try {
                return (Exception)this.decoder.decode(response, (Type)((Object)GitHubClientError.class));
            }
            catch (IOException fallbackToDefault) {
                return this.defaultDecoder.decode(methodKey, response);
            }
        }
    }

    static class GitHubClientError
    extends RuntimeException {
        private String message;

        GitHubClientError() {
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    static interface GitHub {
        @RequestLine(value="GET /users/{username}/repos?sort=full_name")
        public List<Repository> repos(@Param(value="username") String var1);

        @RequestLine(value="GET /repos/{owner}/{repo}/contributors")
        public List<Contributor> contributors(@Param(value="owner") String var1, @Param(value="repo") String var2);

        default public List<String> contributors(String owner) {
            return this.repos(owner).stream().flatMap(repo -> this.contributors(owner, repo.name).stream()).map(c -> c.login).distinct().collect(Collectors.toList());
        }

        public static GitHub connect() {
            GsonDecoder decoder = new GsonDecoder();
            return Feign.builder().decoder(decoder).errorDecoder(new GitHubErrorDecoder(decoder)).logger(new Logger.ErrorLogger()).logLevel(Logger.Level.BASIC).target(GitHub.class, "https://api.github.com");
        }

        public static class Contributor {
            String login;
        }

        public static class Repository {
            String name;
        }
    }
}

