/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.DbcOpenCV;
import scouter.agent.asm.IASM;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.util.Pair;

public class JDBCConnectionOpenASM
implements IASM,
Opcodes {
    private List<HookingSet> target;
    private Map<String, HookingSet> reserved;

    public JDBCConnectionOpenASM() {
        this.target = HookingSet.getHookingMethodSet(Configure.getInstance().hook_connection_open_patterns);
        this.reserved = new HashMap<String, HookingSet>();
        AsmUtil.add(this.reserved, "org/apache/tomcat/dbcp/dbcp/BasicDataSource", "getConnection");
        AsmUtil.add(this.reserved, "org/apache/tomcat/jdbc/pool/DataSourceProxy", "getConnection");
        AsmUtil.add(this.reserved, "org/apache/commons/dbcp2/BasicDataSource", "getConnection");
        for (int i = JDBCTargetRegister.klassMethod.size() - 1; i >= 0; --i) {
            AsmUtil.add(this.reserved, JDBCTargetRegister.klassMethod.get(i).getLeft(), JDBCTargetRegister.klassMethod.get(i).getRight());
        }
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance()._hook_dbconn_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new DbcOpenCV(cv, mset, className);
        }
        for (int i = 0; i < this.target.size(); ++i) {
            mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new DbcOpenCV(cv, mset, className);
        }
        return cv;
    }

    public static class JDBCTargetRegister {
        public static final List<Pair<String, String>> klassMethod = new ArrayList<Pair<String, String>>();

        public static void regist(String klass, String method) {
            klassMethod.add(new Pair<String, String>(klass, method));
        }
    }
}

