/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.HashSet;
import scouter.agent.asm.jdbc.PsClearParametersMV;
import scouter.agent.asm.jdbc.PsCloseMV;
import scouter.agent.asm.jdbc.PsExecuteMV;
import scouter.agent.asm.jdbc.PsInitMV;
import scouter.agent.asm.jdbc.PsSetMV;
import scouter.agent.asm.jdbc.PsUpdateCountMV;
import scouter.agent.asm.jdbc.StExecuteMV;
import scouter.agent.trace.SqlParameter;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;

class PreparedStatementCV
extends ClassVisitor
implements Opcodes {
    HashSet<String> noField;
    private String owner;

    public PreparedStatementCV(ClassVisitor cv, HashSet<String> noField) {
        super(327680, cv);
        this.noField = noField;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.owner = name;
        if (!this.noField.contains(name)) {
            super.visitField(1, "_param_", Type.getDescriptor(SqlParameter.class), null, null).visitEnd();
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("<init>".equals(name)) {
            return new PsInitMV(access, desc, mv, this.owner);
        }
        String targetDesc = PsSetMV.getSetSignature(name);
        if (targetDesc != null) {
            if (targetDesc.equals(desc)) {
                return new PsSetMV(access, name, desc, mv, this.owner);
            }
        } else if (PsExecuteMV.isTarget(name)) {
            if (desc.startsWith("()")) {
                return new PsExecuteMV(access, desc, mv, this.owner, name);
            }
            if (desc.startsWith("(Ljava/lang/String;)")) {
                return new StExecuteMV(access, desc, mv, this.owner, name);
            }
        } else {
            if ("clearParameters".equals(name) && "()V".equals(desc)) {
                return new PsClearParametersMV(access, desc, mv, this.owner);
            }
            if ("getUpdateCount".equals(name) && "()I".equals(desc)) {
                return new PsUpdateCountMV(mv);
            }
            if ("close".equals(name) && "()V".equals(desc)) {
                return new PsCloseMV(mv);
            }
        }
        return mv;
    }
}

