/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.summary;

import java.util.Enumeration;
import scouter.agent.Configure;
import scouter.agent.summary.EndUserAjaxData;
import scouter.agent.summary.EndUserErrorData;
import scouter.agent.summary.EndUserNavigationData;
import scouter.lang.pack.SummaryPack;
import scouter.lang.value.ListValue;
import scouter.util.BitUtil;
import scouter.util.LongKeyLinkedMap;

public class EndUserSummary {
    private static EndUserSummary instance = null;
    private Configure conf = Configure.getInstance();
    private LongKeyLinkedMap<EndUserNavigationData> navTable;
    private LongKeyLinkedMap<EndUserAjaxData> ajaxTable;
    private LongKeyLinkedMap<EndUserErrorData> errorTable;

    public EndUserSummary() {
        this.navTable = new LongKeyLinkedMap().setMax(this.conf._summary_enduser_nav_max_count);
        this.ajaxTable = new LongKeyLinkedMap().setMax(this.conf._summary_enduser_ajax_max_count);
        this.errorTable = new LongKeyLinkedMap().setMax(this.conf._summary_enduser_error_max_count);
    }

    public static final synchronized EndUserSummary getInstance() {
        if (instance == null) {
            instance = new EndUserSummary();
        }
        return instance;
    }

    public void process(EndUserNavigationData data) {
        if (!this.conf.summary_enabled) {
            return;
        }
        long key = BitUtil.composite(data.uri, data.ip);
        EndUserNavigationData d = this.navTable.get(key);
        if (d == null) {
            this.navTable.put(key, data);
            return;
        }
        d.count += data.count;
        d.unloadEventStart += data.unloadEventStart;
        d.unloadEventEnd += data.unloadEventEnd;
        d.fetchStart += data.fetchStart;
        d.domainLookupStart += data.domainLookupStart;
        d.domainLookupEnd += data.domainLookupEnd;
        d.connectStart += data.connectStart;
        d.connectEnd += data.connectEnd;
        d.requestStart += data.requestStart;
        d.responseStart += data.responseStart;
        d.responseEnd += data.responseEnd;
        d.domLoading += data.domLoading;
        d.domInteractive += data.domInteractive;
        d.domContentLoadedEventStart += data.domContentLoadedEventStart;
        d.domContentLoadedEventEnd += data.domContentLoadedEventEnd;
        d.domComplete += data.domComplete;
        d.loadEventStart += data.loadEventStart;
        d.loadEventEnd += data.loadEventEnd;
    }

    public void process(EndUserErrorData data) {
        if (!this.conf.summary_enabled) {
            return;
        }
        long key = BitUtil.composite(data.stacktrace, data.userAgent);
        EndUserErrorData d = this.errorTable.get(key);
        if (d == null) {
            this.errorTable.put(key, data);
            return;
        }
        d.count += data.count;
    }

    public void process(EndUserAjaxData data) {
        if (!this.conf.summary_enabled) {
            return;
        }
        long key = BitUtil.composite(data.uri, data.ip);
        EndUserAjaxData d = this.ajaxTable.get(key);
        if (d == null) {
            this.ajaxTable.put(key, data);
            return;
        }
        d.count += data.count;
        d.duration += data.duration;
    }

    public SummaryPack getAndClearNavTable() {
        if (this.navTable.size() == 0) {
            return null;
        }
        LongKeyLinkedMap<EndUserNavigationData> temp = this.navTable;
        this.navTable = new LongKeyLinkedMap().setMax(this.conf._summary_enduser_nav_max_count);
        SummaryPack p = new SummaryPack();
        p.stype = (byte)10;
        int cnt = temp.size();
        ListValue id = p.table.newList("id");
        ListValue count = p.table.newList("count");
        ListValue uri = p.table.newList("uri");
        ListValue ip = p.table.newList("ip");
        ListValue unloadEventStart = p.table.newList("unloadEventStart");
        ListValue unloadEventEnd = p.table.newList("unloadEventEnd");
        ListValue fetchStart = p.table.newList("fetchStart");
        ListValue domainLookupStart = p.table.newList("domainLookupStart");
        ListValue domainLookupEnd = p.table.newList("domainLookupEnd");
        ListValue connectStart = p.table.newList("connectStart");
        ListValue connectEnd = p.table.newList("connectEnd");
        ListValue requestStart = p.table.newList("requestStart");
        ListValue responseStart = p.table.newList("responseStart");
        ListValue responseEnd = p.table.newList("responseEnd");
        ListValue domLoading = p.table.newList("domLoading");
        ListValue domInteractive = p.table.newList("domInteractive");
        ListValue domContentLoadedEventStart = p.table.newList("domContentLoadedEventStart");
        ListValue domContentLoadedEventEnd = p.table.newList("domContentLoadedEventEnd");
        ListValue domComplete = p.table.newList("domComplete");
        ListValue loadEventStart = p.table.newList("loadEventStart");
        ListValue loadEventEnd = p.table.newList("loadEventEnd");
        Enumeration<LongKeyLinkedMap.LongKeyLinkedEntry<EndUserNavigationData>> en = temp.entries();
        for (int i = 0; i < cnt; ++i) {
            LongKeyLinkedMap.LongKeyLinkedEntry<EndUserNavigationData> ent = en.nextElement();
            long key = ent.getKey();
            EndUserNavigationData data = ent.getValue();
            id.add(key);
            count.add(data.count);
            uri.add(data.uri);
            ip.add(data.ip);
            unloadEventStart.add(data.unloadEventStart);
            unloadEventEnd.add(data.unloadEventEnd);
            fetchStart.add(data.fetchStart);
            domainLookupStart.add(data.domainLookupStart);
            domainLookupEnd.add(data.domainLookupEnd);
            connectStart.add(data.connectStart);
            connectEnd.add(data.connectEnd);
            requestStart.add(data.requestStart);
            responseStart.add(data.responseStart);
            responseEnd.add(data.responseEnd);
            domLoading.add(data.domLoading);
            domInteractive.add(data.domInteractive);
            domContentLoadedEventStart.add(data.domContentLoadedEventStart);
            domContentLoadedEventEnd.add(data.domContentLoadedEventEnd);
            domComplete.add(data.domComplete);
            loadEventStart.add(data.loadEventStart);
            loadEventEnd.add(data.loadEventEnd);
        }
        return p;
    }

    public SummaryPack getAndClearAjaxTable() {
        if (this.ajaxTable.size() == 0) {
            return null;
        }
        LongKeyLinkedMap<EndUserAjaxData> temp = this.ajaxTable;
        this.ajaxTable = new LongKeyLinkedMap().setMax(this.conf._summary_enduser_ajax_max_count);
        SummaryPack p = new SummaryPack();
        p.stype = (byte)11;
        int cnt = temp.size();
        ListValue id = p.table.newList("id");
        ListValue count = p.table.newList("count");
        ListValue uri = p.table.newList("uri");
        ListValue ip = p.table.newList("ip");
        ListValue duration = p.table.newList("duration");
        ListValue userAgent = p.table.newList("userAgent");
        Enumeration<LongKeyLinkedMap.LongKeyLinkedEntry<EndUserAjaxData>> en = temp.entries();
        for (int i = 0; i < cnt; ++i) {
            LongKeyLinkedMap.LongKeyLinkedEntry<EndUserAjaxData> ent = en.nextElement();
            long key = ent.getKey();
            EndUserAjaxData data = ent.getValue();
            id.add(key);
            count.add(data.count);
            uri.add(data.uri);
            ip.add(data.ip);
            duration.add(data.duration);
            userAgent.add(data.userAgent);
        }
        return p;
    }

    public SummaryPack getAndClearErrorTable() {
        if (this.errorTable.size() == 0) {
            return null;
        }
        LongKeyLinkedMap<EndUserErrorData> temp = this.errorTable;
        this.errorTable = new LongKeyLinkedMap().setMax(this.conf._summary_enduser_error_max_count);
        SummaryPack p = new SummaryPack();
        p.stype = (byte)12;
        int cnt = temp.size();
        ListValue id = p.table.newList("id");
        ListValue count = p.table.newList("count");
        ListValue host = p.table.newList("host");
        ListValue stacktrace = p.table.newList("stacktrace");
        ListValue userAgent = p.table.newList("userAgent");
        ListValue uri = p.table.newList("uri");
        ListValue name = p.table.newList("name");
        ListValue message = p.table.newList("message");
        ListValue file = p.table.newList("file");
        ListValue lineNumber = p.table.newList("lineNumber");
        ListValue columnNumber = p.table.newList("columnNumber");
        Enumeration<LongKeyLinkedMap.LongKeyLinkedEntry<EndUserErrorData>> en = temp.entries();
        for (int i = 0; i < cnt; ++i) {
            LongKeyLinkedMap.LongKeyLinkedEntry<EndUserErrorData> ent = en.nextElement();
            long key = ent.getKey();
            EndUserErrorData data = ent.getValue();
            id.add(key);
            count.add(data.count);
            host.add(data.host);
            stacktrace.add(data.stacktrace);
            userAgent.add(data.userAgent);
            uri.add(data.uri);
            name.add(data.name);
            message.add(data.message);
            file.add(data.file);
            lineNumber.add(data.lineNumber);
            columnNumber.add(data.columnNumber);
        }
        return p;
    }
}

