/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.summary;

import java.util.Enumeration;
import scouter.agent.Configure;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.summary.ErrorData;
import scouter.agent.summary.SummaryData;
import scouter.io.DataInputX;
import scouter.lang.pack.SummaryPack;
import scouter.lang.pack.XLogPack;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.SqlStep;
import scouter.lang.value.ListValue;
import scouter.util.BitUtil;
import scouter.util.IPUtil;
import scouter.util.IntIntLinkedMap;
import scouter.util.IntKeyLinkedMap;
import scouter.util.LongKeyLinkedMap;

public class ServiceSummary {
    private static ServiceSummary instance = null;
    private Configure conf = Configure.getInstance();
    private LongKeyLinkedMap<ErrorData> errorMaster;
    private IntKeyLinkedMap<SummaryData> sqlMaster;
    private IntKeyLinkedMap<SummaryData> apiMaster;
    private IntKeyLinkedMap<SummaryData> serviceMaster;
    private IntIntLinkedMap ipMaster;
    private IntIntLinkedMap uaMaster;

    public ServiceSummary() {
        this.errorMaster = new LongKeyLinkedMap().setMax(this.conf._summary_error_max_count);
        this.sqlMaster = new IntKeyLinkedMap().setMax(this.conf._summary_sql_max_count);
        this.apiMaster = new IntKeyLinkedMap().setMax(this.conf._summary_api_max_count);
        this.serviceMaster = new IntKeyLinkedMap().setMax(this.conf._summary_service_max_count);
        this.ipMaster = new IntIntLinkedMap().setMax(this.conf._summary_ip_max_count);
        this.uaMaster = new IntIntLinkedMap().setMax(this.conf._summary_useragent_max_count);
    }

    public static final synchronized ServiceSummary getInstance() {
        if (instance == null) {
            instance = new ServiceSummary();
        }
        return instance;
    }

    public void process(XLogPack p) {
        if (!this.conf.summary_enabled) {
            return;
        }
        SummaryData d = this.getSummaryMap(this.serviceMaster, p.service);
        ++d.count;
        d.elapsed += (long)p.elapsed;
        if (p.error != 0) {
            ++d.error_cnt;
        }
        d.cpu += (long)p.cpu;
        d.mem += (long)p.kbytes;
        if (IPUtil.isOK(p.ipaddr) && p.ipaddr[0] != 0 && p.ipaddr[0] != 127) {
            int ip = DataInputX.toInt(p.ipaddr, 0);
            this.ipMaster.put(ip, this.ipMaster.get(ip) + 1);
        }
        if (p.userAgent != 0) {
            this.uaMaster.put(p.userAgent, this.uaMaster.get(p.userAgent) + 1);
        }
    }

    public ErrorData process(Throwable thr, int message, int service, long txid, int sql, int api) {
        if (!this.conf.summary_enabled) {
            return null;
        }
        String errName = thr.getClass().getName();
        int errHash = DataProxy.sendError(errName);
        ErrorData errData = this.getSummaryError(this.errorMaster, BitUtil.composite(errHash, service));
        errData.error = errHash;
        errData.service = service;
        errData.message = message == 0 ? errHash : message;
        ++errData.count;
        errData.txid = txid;
        if (sql != 0) {
            errData.sql = sql;
        }
        if (api != 0) {
            errData.apicall = api;
        }
        return errData;
    }

    public void process(SqlStep sqlStep) {
        if (!this.conf.summary_enabled) {
            return;
        }
        SummaryData d = this.getSummaryMap(this.sqlMaster, sqlStep.hash);
        ++d.count;
        d.elapsed += (long)sqlStep.elapsed;
        if (sqlStep.error != 0) {
            ++d.error_cnt;
        }
    }

    public void process(ApiCallStep apiStep) {
        if (!this.conf.summary_enabled) {
            return;
        }
        SummaryData d = this.getSummaryMap(this.apiMaster, apiStep.hash);
        ++d.count;
        d.elapsed += (long)apiStep.elapsed;
        if (apiStep.error != 0) {
            ++d.error_cnt;
        }
    }

    private synchronized SummaryData getSummaryMap(IntKeyLinkedMap<SummaryData> table, int hash) {
        IntKeyLinkedMap<SummaryData> tempTable = table;
        SummaryData d = tempTable.get(hash);
        if (d == null) {
            d = new SummaryData();
            tempTable.put(hash, d);
        }
        return d;
    }

    private synchronized ErrorData getSummaryError(LongKeyLinkedMap<ErrorData> table, long key) {
        LongKeyLinkedMap<ErrorData> tempTable = table;
        ErrorData d = tempTable.get(key);
        if (d == null) {
            d = new ErrorData();
            tempTable.put(key, d);
        }
        return d;
    }

    public SummaryPack getAndClear(byte type) {
        IntKeyLinkedMap<SummaryData> temp;
        switch (type) {
            case 1: {
                if (this.serviceMaster.size() == 0) {
                    return null;
                }
                temp = this.serviceMaster;
                this.serviceMaster = new IntKeyLinkedMap().setMax(this.conf._summary_service_max_count);
                break;
            }
            case 2: {
                if (this.sqlMaster.size() == 0) {
                    return null;
                }
                temp = this.sqlMaster;
                this.sqlMaster = new IntKeyLinkedMap().setMax(this.conf._summary_sql_max_count);
                break;
            }
            case 5: {
                if (this.apiMaster.size() == 0) {
                    return null;
                }
                temp = this.apiMaster;
                this.apiMaster = new IntKeyLinkedMap().setMax(this.conf._summary_api_max_count);
                break;
            }
            default: {
                return null;
            }
        }
        SummaryPack p = new SummaryPack();
        p.stype = type;
        int cnt = temp.size();
        ListValue id = p.table.newList("id");
        ListValue count = p.table.newList("count");
        ListValue errorCnt = p.table.newList("error");
        ListValue elapsedSum = p.table.newList("elapsed");
        ListValue cpu = null;
        ListValue mem = null;
        if (1 == type) {
            cpu = p.table.newList("cpu");
            mem = p.table.newList("mem");
        }
        Enumeration<IntKeyLinkedMap.IntKeyLinkedEntry<SummaryData>> en = temp.entries();
        for (int i = 0; i < cnt; ++i) {
            IntKeyLinkedMap.IntKeyLinkedEntry<SummaryData> ent = en.nextElement();
            int key = ent.getKey();
            SummaryData data = ent.getValue();
            id.add(key);
            count.add(data.count);
            errorCnt.add(data.error_cnt);
            elapsedSum.add(data.elapsed);
            if (1 != type) continue;
            cpu.add(data.cpu);
            mem.add(data.mem);
        }
        return p;
    }

    public SummaryPack getAndClearX(byte type) {
        IntIntLinkedMap temp;
        switch (type) {
            case 4: {
                if (this.ipMaster.size() == 0) {
                    return null;
                }
                temp = this.ipMaster;
                this.ipMaster = new IntIntLinkedMap().setMax(this.conf._summary_ip_max_count);
                break;
            }
            case 8: {
                if (this.uaMaster.size() == 0) {
                    return null;
                }
                temp = this.uaMaster;
                this.uaMaster = new IntIntLinkedMap().setMax(this.conf._summary_useragent_max_count);
                break;
            }
            default: {
                return null;
            }
        }
        SummaryPack p = new SummaryPack();
        p.stype = type;
        int cnt = temp.size();
        ListValue id = p.table.newList("id");
        ListValue count = p.table.newList("count");
        Enumeration<IntIntLinkedMap.IntIntLinkedEntry> en = temp.entries();
        for (int i = 0; i < cnt; ++i) {
            IntIntLinkedMap.IntIntLinkedEntry ent = en.nextElement();
            int key = ent.getKey();
            int value = ent.getValue();
            id.add(key);
            count.add(value);
        }
        return p;
    }

    public SummaryPack getAndClearError(byte type) {
        if (this.errorMaster.size() == 0) {
            return null;
        }
        LongKeyLinkedMap<ErrorData> temp = this.errorMaster;
        this.errorMaster = new LongKeyLinkedMap().setMax(this.conf._summary_error_max_count);
        SummaryPack p = new SummaryPack();
        p.stype = type;
        int cnt = temp.size();
        ListValue id = p.table.newList("id");
        ListValue error = p.table.newList("error");
        ListValue service = p.table.newList("service");
        ListValue message = p.table.newList("message");
        ListValue count = p.table.newList("count");
        ListValue txid = p.table.newList("txid");
        ListValue sql = p.table.newList("sql");
        ListValue apicall = p.table.newList("apicall");
        ListValue fullstack = p.table.newList("fullstack");
        Enumeration<LongKeyLinkedMap.LongKeyLinkedEntry<ErrorData>> en = temp.entries();
        for (int i = 0; i < cnt; ++i) {
            LongKeyLinkedMap.LongKeyLinkedEntry<ErrorData> ent = en.nextElement();
            long key = ent.getKey();
            ErrorData data = ent.getValue();
            id.add(key);
            error.add(data.error);
            service.add(data.service);
            message.add(data.message);
            count.add(data.count);
            txid.add(data.txid);
            sql.add(data.sql);
            apicall.add(data.apicall);
            fullstack.add(data.fullstack);
        }
        return p;
    }
}

