/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.text.DecimalFormat;
import scouter.lang.value.BooleanValue;

public class CastUtil {
    public static int cint(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(CastUtil.toString(value));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static Integer cInteger(Object value) {
        return CastUtil.cint(value);
    }

    public static long clong(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.parseLong(CastUtil.toString(value));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static Long cLong(Object value) {
        return CastUtil.clong(value);
    }

    public static float cfloat(Object value) {
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        try {
            return Float.parseFloat(CastUtil.toString(value));
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static Float cFloat(Object value) {
        return Float.valueOf(CastUtil.cfloat(value));
    }

    public static double cdouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(CastUtil.toString(value));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static Double cDouble(Object value) {
        return CastUtil.cdouble(value);
    }

    private static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static String cString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Number) {
            if (value instanceof Double || value instanceof Float) {
                return new DecimalFormat("#0.0#######").format(value);
            }
            return new DecimalFormat("#0").format(value);
        }
        return CastUtil.toString(value);
    }

    public static boolean cboolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).value;
        }
        return "true".equalsIgnoreCase(CastUtil.toString(value));
    }

    public static Boolean cBoolean(Object value) {
        return CastUtil.cboolean(value);
    }

    public static void main(String[] args) {
        System.out.println((long)CastUtil.cdouble("9876544321.0"));
    }
}

