/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import scouter.util.DateTimeHelper;
import scouter.util.SysJMX;

public class DateUtil {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_FIVE_MINUTE = 300000L;
    public static final long MILLIS_PER_TEN_MINUTE = 600000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SECONDS_PER_DAY = 86400;
    public static final DateTimeHelper helper = DateTimeHelper.getDefault();
    private static Hashtable<String, SimpleDateFormat> parsers = new Hashtable();

    public static String datetime(long time) {
        return helper.datetime(time);
    }

    public static String timestamp(long time) {
        return helper.timestamp(time);
    }

    public static String yyyymmdd(long time) {
        return helper.yyyymmdd(time);
    }

    public static long getDateUnit() {
        return helper.getDateUnit();
    }

    public static long getDateUnit(long time) {
        return helper.getDateUnit(time);
    }

    public static String ymdhms(long time) {
        return helper.yyyymmdd(time) + helper.hhmmss(time);
    }

    public static String hhmmss(long time) {
        return helper.hhmmss(time);
    }

    public static String hhmm(long now) {
        return helper.hhmm(now);
    }

    public static String yyyymmdd() {
        return helper.yyyymmdd(System.currentTimeMillis());
    }

    public static String getLogTime(long time) {
        return helper.logtime(time);
    }

    public static long yyyymmdd(String date) {
        return helper.yyyymmdd(date);
    }

    public static long hhmm(String date) {
        return helper.hhmm(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTime(String date, String format) {
        if (format.equals("yyyyMMdd")) {
            return helper.yyyymmdd(date);
        }
        try {
            SimpleDateFormat sdf = parsers.get(format);
            if (sdf == null) {
                sdf = new SimpleDateFormat(format);
                parsers.put(format, sdf);
            }
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                return sdf.parse(date).getTime();
            }
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(long stime, String format) {
        if (format.equals("yyyyMMdd")) {
            return helper.yyyymmdd(stime);
        }
        SimpleDateFormat sdf = parsers.get(format);
        if (sdf == null) {
            sdf = new SimpleDateFormat(format);
            parsers.put(format, sdf);
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            return sdf.format(new Date(stime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(long stime, String format, Locale locale) {
        if (format.equals("yyyyMMdd")) {
            return helper.yyyymmdd(stime);
        }
        SimpleDateFormat sdf = parsers.get(format + locale.getCountry());
        if (sdf == null) {
            sdf = new SimpleDateFormat(format, locale);
            parsers.put(format + locale.getCountry(), sdf);
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            return sdf.format(new Date(stime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parse(String date, String format) {
        if (format.equals("yyyyMMdd")) {
            return helper.yyyymmdd(date);
        }
        SimpleDateFormat sdf = parsers.get(format);
        if (sdf == null) {
            sdf = new SimpleDateFormat(format);
            parsers.put(format, sdf);
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            try {
                return sdf.parse(date).getTime();
            }
            catch (ParseException e) {
                return helper.getBaseTime();
            }
        }
    }

    public static boolean isSameDay(Date date, Date date2) {
        return helper.getDateUnit(date.getTime()) == helper.getDateUnit(date2.getTime());
    }

    public static boolean isToday(long time) {
        return helper.getDateUnit(time) == helper.getDateUnit(System.currentTimeMillis());
    }

    public static int getHour(Date date) {
        return helper.getHour(date.getTime());
    }

    public static int getMin(Date date) {
        return helper.getMM(date.getTime());
    }

    public static int getHour(long time) {
        return helper.getHour(time);
    }

    public static int getMin(long time) {
        return helper.getMM(time);
    }

    public static String timestamp() {
        return helper.timestamp(System.currentTimeMillis());
    }

    public static String timestampFileName() {
        return helper.timestampFileName(System.currentTimeMillis());
    }

    public static int getDateMillis(long time) {
        return helper.getDateMillis(time);
    }

    public static long getTimeUnit(long time) {
        return helper.getTimeUnit(time);
    }

    public static long getHourUnit(long time) {
        return helper.getHourUnit(time);
    }

    public static long getTenMinUnit(long time) {
        return helper.getTenMinUnit(time);
    }

    public static long getMinUnit(long time) {
        return helper.getMinUnit(time);
    }

    public static long reverseHourUnit(long unit) {
        return helper.reverseHourUnit(unit);
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) throws ParseException {
        long time;
        String date;
        int i;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HH:mm:ss.S");
        long cpu = SysJMX.getCurrentThreadCPUnano();
        for (i = 0; i < 10000; ++i) {
            date = sdf.format(new Date(System.currentTimeMillis() + (long)i));
        }
        cpu = SysJMX.getCurrentThreadCPUnano() - cpu;
        System.out.println("SimpleDateFormat.format " + cpu / 1000000L + " ms");
        cpu = SysJMX.getCurrentThreadCPUnano();
        for (i = 0; i < 10000; ++i) {
            date = DateUtil.timestamp(System.currentTimeMillis() + (long)i);
        }
        cpu = SysJMX.getCurrentThreadCPUnano() - cpu;
        System.out.println("DateUtil.format " + cpu / 1000000L + " ms");
        sdf = new SimpleDateFormat("yyyyMMdd");
        cpu = SysJMX.getCurrentThreadCPUnano();
        for (i = 0; i < 10000; ++i) {
            time = sdf.parse("20101123").getTime();
        }
        cpu = SysJMX.getCurrentThreadCPUnano() - cpu;
        System.out.println("SimpleDateFormat.parse " + cpu / 1000000L + " ms");
        cpu = SysJMX.getCurrentThreadCPUnano();
        for (i = 0; i < 10000; ++i) {
            time = DateUtil.yyyymmdd("20101123");
        }
        cpu = SysJMX.getCurrentThreadCPUnano() - cpu;
        System.out.println("DateUtil.parse  " + cpu / 1000000L + " ms");
    }
}

