/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import java.util.Map;
import java.util.Set;
import scouter.agent.Configure;
import scouter.agent.trace.CoroutineDebuggingLocal;
import scouter.agent.trace.TraceContext;
import scouter.agent.util.SimpleLru;
import scouter.util.KeyGen;
import scouter.util.LongLongLinkedMap;

public class TraceContextManager {
    private static Configure conf = Configure.getInstance();
    private static SimpleLru<Long, TraceContext> entryByThreadId = new SimpleLru(10000);
    private static SimpleLru<Long, TraceContext> entryByTxid = new SimpleLru(10000);
    private static SimpleLru<Long, TraceContext> deferredEntry = new SimpleLru(10000);
    private static final ThreadLocal<TraceContext> local = new ThreadLocal();
    private static final ThreadLocal<Long> txidLocal = new ThreadLocal();
    public static final ThreadLocal<Long> txidByCoroutine = new ThreadLocal();
    private static CoroutineDebuggingLocal<TraceContext> coroutineDebuggingLocal = new CoroutineDebuggingLocal();
    private static ThreadLocal<Integer> forceDiscard = new ThreadLocal();
    private static boolean coroutineEnabled;
    private static boolean coroutineDebuggingEnabled;
    private static LongLongLinkedMap threadTxidMap;
    private static LongLongLinkedMap txidThreadMap;

    public static int size() {
        return entryByTxid.size();
    }

    public static int[] getActiveCount() {
        int[] act = new int[3];
        try {
            long now = System.currentTimeMillis();
            for (Map.Entry<Long, TraceContext> e : entryByTxid.entrySet()) {
                TraceContext ctx = e.getValue();
                long tm = now - ctx.startTime;
                if (tm < TraceContextManager.conf.trace_activeserivce_yellow_time) {
                    act[0] = act[0] + 1;
                    continue;
                }
                if (tm < TraceContextManager.conf.trace_activeservice_red_time) {
                    act[1] = act[1] + 1;
                    continue;
                }
                act[2] = act[2] + 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return act;
    }

    public static Set<Map.Entry<Long, TraceContext>> getContextEntries() {
        return entryByTxid.entrySet();
    }

    public static Set<Map.Entry<Long, TraceContext>> getThreadingContextEntries() {
        return entryByThreadId.entrySet();
    }

    public static Set<Map.Entry<Long, TraceContext>> getDeferredContextEntries() {
        return deferredEntry.entrySet();
    }

    public static TraceContext getContext() {
        return TraceContextManager.getContext(false);
    }

    public static TraceContext getContext(boolean force) {
        TraceContext traceContext;
        if (!force && TraceContextManager.conf.profile_off) {
            return null;
        }
        Long txid = txidLocal.get();
        TraceContext traceContext2 = traceContext = txid == null ? null : entryByTxid.get(txid);
        if (traceContext != null) {
            traceContext.getBy = TraceContext.GetBy.ThreadLocalTxid;
            return traceContext;
        }
        if (coroutineEnabled) {
            txid = txidByCoroutine.get();
            TraceContext traceContext3 = traceContext = txid == null ? null : entryByTxid.get(txid);
            if (traceContext != null) {
                traceContext.getBy = TraceContext.GetBy.ThreadLocalTxidByCoroutine;
                return traceContext;
            }
        }
        if ((traceContext = local.get()) != null) {
            traceContext.getBy = TraceContext.GetBy.ThreadLocal;
            return traceContext;
        }
        if (coroutineDebuggingEnabled && (traceContext = TraceContextManager.getCoroutineContext()) != null) {
            traceContext.getBy = TraceContext.GetBy.CoroutineLocal;
            return traceContext;
        }
        return null;
    }

    public static TraceContext getContextByTxid(long txid) {
        return entryByTxid.get(txid);
    }

    public static TraceContext getContextByThreadId(long key) {
        return entryByThreadId.get(key);
    }

    public static TraceContext getDeferredContext(long key) {
        return deferredEntry.get(key);
    }

    public static TraceContext getCoroutineContext() {
        return coroutineDebuggingLocal.get();
    }

    public static TraceContext getCoroutineContext(long id) {
        return coroutineDebuggingLocal.get(id);
    }

    public static Long getLocalTxid() {
        return txidLocal.get();
    }

    public static void clearForceDiscard() {
        if (!TraceContextManager.conf._xlog_hard_sampling_enabled) {
            return;
        }
        Integer num = forceDiscard.get();
        if (num == null) {
            forceDiscard.set(-1);
        } else if (num == 1) {
            forceDiscard.set(-1);
        } else if (num == 2) {
            forceDiscard.set(-2);
        }
    }

    public static boolean isForceDiscarded() {
        if (!TraceContextManager.conf._xlog_hard_sampling_enabled) {
            return false;
        }
        boolean discard = false;
        Integer num = forceDiscard.get();
        if (num == null) {
            return false;
        }
        if (num == 2 || num == -2) {
            discard = true;
        }
        return discard;
    }

    public static boolean startForceDiscard() {
        if (!TraceContextManager.conf._xlog_hard_sampling_enabled) {
            return false;
        }
        boolean discard = false;
        Integer num = forceDiscard.get();
        if (num == null || num == -1 || num == -2) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)TraceContextManager.conf._xlog_hard_sampling_rate_pct) {
                discard = true;
                forceDiscard.set(2);
            } else {
                forceDiscard.set(1);
            }
        } else if (num == 2) {
            discard = true;
        }
        return discard;
    }

    public static void start(TraceContext o) {
        local.set(o);
        txidLocal.set(o.txid);
        entryByTxid.put(o.txid, o);
        if (!o.isReactiveStarted) {
            entryByThreadId.put(o.threadId, o);
        }
    }

    public static void takeoverTxid(TraceContext o, long oldTxid) {
        txidLocal.set(o.txid);
        entryByTxid.remove(oldTxid);
        entryByTxid.put(o.txid, o);
    }

    public static void startByCoroutine(TraceContext o) {
        coroutineEnabled = true;
        txidByCoroutine.set(o.txid);
    }

    public static void end(TraceContext o) {
        TraceContextManager.clearAllContext(o);
    }

    public static void setTxidLocal(Long txid) {
        txidLocal.set(txid);
        if (txid != null && TraceContextManager.conf._psts_enabled && TraceContextManager.conf._psts_progressive_reactor_thread_trace_enabled) {
            long threadId = Thread.currentThread().getId();
            txidThreadMap.put(txid, threadId);
            threadTxidMap.put(threadId, txid);
        }
    }

    public static long getReactiveThreadId(long txid) {
        if (!TraceContextManager.conf._psts_progressive_reactor_thread_trace_enabled) {
            return 0L;
        }
        long threadId = txidThreadMap.get(txid);
        if (threadId == 0L) {
            return 0L;
        }
        long txid0 = threadTxidMap.get(threadId);
        if (txid0 == txid) {
            return threadId;
        }
        return 0L;
    }

    public static void asCoroutineDebuggingMode(Long coroutineId, TraceContext o) {
        CoroutineDebuggingLocal.setCoroutineDebuggingId(coroutineId);
        coroutineDebuggingLocal.put(o);
        local.set(null);
        coroutineDebuggingEnabled = true;
    }

    public static void toDeferred(TraceContext o) {
        deferredEntry.put(o.txid, o);
    }

    public static void completeDeferred(TraceContext o) {
        deferredEntry.remove(o.txid);
    }

    public static void clearAllContext(TraceContext o) {
        o._req = null;
        o._res = null;
        local.set(null);
        coroutineDebuggingLocal.clear();
        entryByTxid.remove(o.txid);
        if (TraceContextManager.conf._psts_progressive_reactor_thread_trace_enabled) {
            txidThreadMap.remove(o.txid);
        }
        txidByCoroutine.set(null);
        if (!o.isReactiveStarted) {
            txidLocal.set(null);
            entryByThreadId.remove(o.threadId);
        }
        TraceContextManager.clearForceDiscard();
    }

    static {
        threadTxidMap = new LongLongLinkedMap().setMax(2000);
        txidThreadMap = new LongLongLinkedMap().setMax(2000);
    }
}

